/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.ServiceCategoryBag;
import org.apache.juddi.model.ServiceDescr;
import org.apache.juddi.model.ServiceName;
import org.apache.juddi.model.ServiceProjection;
import org.apache.juddi.model.UddiEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="j3_business_service")
public class BusinessService
extends UddiEntity
implements Serializable {
    private static final long serialVersionUID = 7793243417208829793L;
    private BusinessEntity businessEntity;
    private List<ServiceName> serviceNames = new ArrayList<ServiceName>(0);
    private List<ServiceDescr> serviceDescrs = new ArrayList<ServiceDescr>(0);
    private List<BindingTemplate> bindingTemplates = new ArrayList<BindingTemplate>(0);
    private ServiceCategoryBag categoryBag;
    private List<ServiceProjection> projectingBusinesses = new ArrayList<ServiceProjection>(0);

    public BusinessService() {
    }

    public BusinessService(String entityKey, BusinessEntity businessEntity, Date modified) {
        this.entityKey = entityKey;
        this.businessEntity = businessEntity;
        this.modified = modified;
    }

    public BusinessService(String entityKey, BusinessEntity businessEntity, Date modified, List<ServiceName> serviceNames, List<ServiceDescr> serviceDescrs, List<BindingTemplate> bindingTemplates, ServiceCategoryBag categoryBag) {
        this.entityKey = entityKey;
        this.businessEntity = businessEntity;
        this.modified = modified;
        this.serviceNames = serviceNames;
        this.serviceDescrs = serviceDescrs;
        this.bindingTemplates = bindingTemplates;
        this.categoryBag = categoryBag;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="business_key", nullable=false)
    public BusinessEntity getBusinessEntity() {
        return this.businessEntity;
    }

    public void setBusinessEntity(BusinessEntity businessEntity) {
        this.businessEntity = businessEntity;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="businessService")
    @OrderBy
    public List<ServiceName> getServiceNames() {
        return this.serviceNames;
    }

    public void setServiceNames(List<ServiceName> serviceNames) {
        this.serviceNames = serviceNames;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="businessService")
    @OrderBy
    public List<ServiceDescr> getServiceDescrs() {
        return this.serviceDescrs;
    }

    public void setServiceDescrs(List<ServiceDescr> serviceDescrs) {
        this.serviceDescrs = serviceDescrs;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="businessService")
    @OrderBy
    public List<BindingTemplate> getBindingTemplates() {
        return this.bindingTemplates;
    }

    public void setBindingTemplates(List<BindingTemplate> bindingTemplates) {
        this.bindingTemplates = bindingTemplates;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="businessService")
    public ServiceCategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(ServiceCategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="businessService")
    public List<ServiceProjection> getProjectingBusinesses() {
        return this.projectingBusinesses;
    }

    public void setProjectingBusinesses(List<ServiceProjection> projectingBusinesses) {
        this.projectingBusinesses = projectingBusinesses;
    }
}

