/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.mapping;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.apache.juddi.model.Address;
import org.apache.juddi.model.BindingDescr;
import org.apache.juddi.model.BusinessDescr;
import org.apache.juddi.model.BusinessIdentifier;
import org.apache.juddi.model.BusinessName;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.CategoryBag;
import org.apache.juddi.model.Clerk;
import org.apache.juddi.model.ClientSubscriptionInfo;
import org.apache.juddi.model.Contact;
import org.apache.juddi.model.ContactDescr;
import org.apache.juddi.model.DiscoveryUrl;
import org.apache.juddi.model.Email;
import org.apache.juddi.model.InstanceDetailsDescr;
import org.apache.juddi.model.Node;
import org.apache.juddi.model.OverviewDoc;
import org.apache.juddi.model.OverviewDocDescr;
import org.apache.juddi.model.PersonName;
import org.apache.juddi.model.Phone;
import org.apache.juddi.model.Publisher;
import org.apache.juddi.model.ServiceDescr;
import org.apache.juddi.model.ServiceName;
import org.apache.juddi.model.ServiceProjection;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.TmodelDescr;
import org.apache.juddi.model.TmodelIdentifier;
import org.apache.juddi.model.TmodelInstanceInfo;
import org.apache.juddi.model.TmodelInstanceInfoDescr;
import org.apache.juddi.model.UddiEntity;
import org.apache.juddi.subscription.TypeConvertor;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.log4j.Logger;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.AddressLine;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.Contacts;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.Direction;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeyedReferenceGroup;
import org.uddi.api_v3.KeysOwned;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.RelatedBusinessInfo;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.SharedRelationships;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionFilter;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingModelToApi {
    private static Logger logger = Logger.getLogger(MappingModelToApi.class);

    public static void mapPublisher(Publisher modelPublisher, org.apache.juddi.api_v3.Publisher apiPublisher) throws DispositionReportFaultMessage {
        apiPublisher.setAuthorizedName(modelPublisher.getAuthorizedName());
        apiPublisher.setPublisherName(modelPublisher.getPublisherName());
        apiPublisher.setEmailAddress(modelPublisher.getEmailAddress());
        apiPublisher.setIsAdmin(modelPublisher.getIsAdmin());
        apiPublisher.setIsEnabled(modelPublisher.getIsEnabled());
        apiPublisher.setMaxBindingsPerService(modelPublisher.getMaxBindingsPerService());
        apiPublisher.setMaxBusinesses(modelPublisher.getMaxBusinesses());
        apiPublisher.setMaxServicePerBusiness(modelPublisher.getMaxServicesPerBusiness());
        apiPublisher.setMaxTModels(modelPublisher.getMaxTmodels());
    }

    public static void mapBusinessEntity(org.apache.juddi.model.BusinessEntity modelBusinessEntity, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        apiBusinessEntity.setBusinessKey(modelBusinessEntity.getEntityKey());
        MappingModelToApi.mapBusinessNames(modelBusinessEntity.getBusinessNames(), apiBusinessEntity.getName());
        MappingModelToApi.mapBusinessDescriptions(modelBusinessEntity.getBusinessDescrs(), apiBusinessEntity.getDescription());
        MappingModelToApi.mapDiscoveryUrls(modelBusinessEntity.getDiscoveryUrls(), apiBusinessEntity.getDiscoveryURLs(), apiBusinessEntity);
        MappingModelToApi.mapContacts(modelBusinessEntity.getContacts(), apiBusinessEntity.getContacts(), apiBusinessEntity);
        MappingModelToApi.mapBusinessIdentifiers(modelBusinessEntity.getBusinessIdentifiers(), apiBusinessEntity.getIdentifierBag(), apiBusinessEntity);
        apiBusinessEntity.setCategoryBag(MappingModelToApi.mapCategoryBag(modelBusinessEntity.getCategoryBag(), apiBusinessEntity.getCategoryBag()));
        MappingModelToApi.mapBusinessServices(modelBusinessEntity.getBusinessServices(), modelBusinessEntity.getServiceProjections(), apiBusinessEntity.getBusinessServices(), apiBusinessEntity);
    }

    public static void mapBusinessNames(List<BusinessName> modelNameList, List<Name> apiNameList) throws DispositionReportFaultMessage {
        apiNameList.clear();
        for (BusinessName modelName : modelNameList) {
            Name apiName = new Name();
            apiName.setLang(modelName.getLangCode());
            apiName.setValue(modelName.getName());
            apiNameList.add(apiName);
        }
    }

    public static void mapBusinessDescriptions(List<BusinessDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (BusinessDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapDiscoveryUrls(List<DiscoveryUrl> modelDiscUrlList, DiscoveryURLs apiDiscUrls, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        if (modelDiscUrlList == null || modelDiscUrlList.size() == 0) {
            return;
        }
        if (apiDiscUrls == null) {
            apiDiscUrls = new DiscoveryURLs();
        }
        List apiDiscUrlList = apiDiscUrls.getDiscoveryURL();
        apiDiscUrlList.clear();
        for (DiscoveryUrl modelDiscUrl : modelDiscUrlList) {
            DiscoveryURL apiDiscUrl = new DiscoveryURL();
            apiDiscUrl.setUseType(modelDiscUrl.getUseType());
            apiDiscUrl.setValue(modelDiscUrl.getUrl());
            apiDiscUrlList.add(apiDiscUrl);
        }
        apiBusinessEntity.setDiscoveryURLs(apiDiscUrls);
    }

    public static void mapContacts(List<Contact> modelContactList, Contacts apiContacts, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        if (modelContactList == null || modelContactList.size() == 0) {
            return;
        }
        if (apiContacts == null) {
            apiContacts = new Contacts();
        }
        List apiContactList = apiContacts.getContact();
        apiContactList.clear();
        for (Contact modelContact : modelContactList) {
            org.uddi.api_v3.Contact apiContact = new org.uddi.api_v3.Contact();
            apiContact.setUseType(modelContact.getUseType());
            MappingModelToApi.mapPersonNames(modelContact.getPersonNames(), apiContact.getPersonName());
            MappingModelToApi.mapContactDescriptions(modelContact.getContactDescrs(), apiContact.getDescription());
            MappingModelToApi.mapContactEmails(modelContact.getEmails(), apiContact.getEmail());
            MappingModelToApi.mapContactPhones(modelContact.getPhones(), apiContact.getPhone());
            MappingModelToApi.mapContactAddresses(modelContact.getAddresses(), apiContact.getAddress());
            apiContactList.add(apiContact);
        }
        apiBusinessEntity.setContacts(apiContacts);
    }

    public static void mapContactDescriptions(List<ContactDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (ContactDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapPersonNames(List<PersonName> modelPersonNameList, List<org.uddi.api_v3.PersonName> apiPersonNameList) throws DispositionReportFaultMessage {
        apiPersonNameList.clear();
        for (PersonName personName : modelPersonNameList) {
            org.uddi.api_v3.PersonName apiPersonName = new org.uddi.api_v3.PersonName();
            apiPersonName.setLang(personName.getLangCode());
            apiPersonName.setValue(personName.getName());
            apiPersonNameList.add(apiPersonName);
        }
    }

    public static void mapContactEmails(List<Email> modelEmailList, List<org.uddi.api_v3.Email> apiEmailList) throws DispositionReportFaultMessage {
        apiEmailList.clear();
        for (Email modelEmail : modelEmailList) {
            org.uddi.api_v3.Email apiEmail = new org.uddi.api_v3.Email();
            apiEmail.setUseType(modelEmail.getUseType());
            apiEmail.setValue(modelEmail.getEmailAddress());
            apiEmailList.add(apiEmail);
        }
    }

    public static void mapContactPhones(List<Phone> modelPhoneList, List<org.uddi.api_v3.Phone> apiPhoneList) throws DispositionReportFaultMessage {
        apiPhoneList.clear();
        for (Phone modelPhone : modelPhoneList) {
            org.uddi.api_v3.Phone apiPhone = new org.uddi.api_v3.Phone();
            apiPhone.setUseType(modelPhone.getUseType());
            apiPhone.setValue(modelPhone.getPhoneNumber());
            apiPhoneList.add(apiPhone);
        }
    }

    public static void mapContactAddresses(List<Address> modelAddressList, List<org.uddi.api_v3.Address> apiAddressList) throws DispositionReportFaultMessage {
        apiAddressList.clear();
        for (Address modelAddress : modelAddressList) {
            org.uddi.api_v3.Address apiAddress = new org.uddi.api_v3.Address();
            apiAddress.setUseType(modelAddress.getUseType());
            apiAddress.setLang("");
            apiAddress.setSortCode(modelAddress.getSortCode());
            apiAddress.setTModelKey(modelAddress.getTmodelKey());
            MappingModelToApi.mapAddressLines(modelAddress.getAddressLines(), apiAddress.getAddressLine());
            apiAddressList.add(apiAddress);
        }
    }

    public static void mapAddressLines(List<org.apache.juddi.model.AddressLine> modelAddressLineList, List<AddressLine> apiAddressLineList) throws DispositionReportFaultMessage {
        apiAddressLineList.clear();
        for (org.apache.juddi.model.AddressLine modelAddressLine : modelAddressLineList) {
            AddressLine apiAddressLine = new AddressLine();
            apiAddressLine.setKeyName(modelAddressLine.getKeyName());
            apiAddressLine.setKeyName(modelAddressLine.getKeyValue());
            apiAddressLine.setValue(modelAddressLine.getLine());
            apiAddressLineList.add(apiAddressLine);
        }
    }

    public static void mapBusinessIdentifiers(List<BusinessIdentifier> modelIdentifierList, IdentifierBag apiIdentifierBag, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        if (modelIdentifierList == null || modelIdentifierList.size() == 0) {
            return;
        }
        if (apiIdentifierBag == null) {
            apiIdentifierBag = new IdentifierBag();
        }
        List apiKeyedRefList = apiIdentifierBag.getKeyedReference();
        apiKeyedRefList.clear();
        for (BusinessIdentifier modelIdentifier : modelIdentifierList) {
            KeyedReference apiKeyedRef = new KeyedReference();
            apiKeyedRef.setTModelKey(modelIdentifier.getTmodelKeyRef());
            apiKeyedRef.setKeyName(modelIdentifier.getKeyName());
            apiKeyedRef.setKeyValue(modelIdentifier.getKeyValue());
            apiKeyedRefList.add(apiKeyedRef);
        }
        apiBusinessEntity.setIdentifierBag(apiIdentifierBag);
    }

    public static void mapBusinessServices(List<BusinessService> modelBusinessServiceList, List<ServiceProjection> modelServiceProjectionList, BusinessServices apiBusinessServices, BusinessEntity apiBusinessEntity) throws DispositionReportFaultMessage {
        org.uddi.api_v3.BusinessService apiBusinessService;
        if (apiBusinessServices == null) {
            apiBusinessServices = new BusinessServices();
        }
        List apiBusinessServiceList = apiBusinessServices.getBusinessService();
        apiBusinessServiceList.clear();
        if (modelBusinessServiceList != null && modelBusinessServiceList.size() > 0) {
            for (BusinessService modelBusinessService : modelBusinessServiceList) {
                apiBusinessService = new org.uddi.api_v3.BusinessService();
                MappingModelToApi.mapBusinessService(modelBusinessService, apiBusinessService);
                apiBusinessServiceList.add(apiBusinessService);
            }
        }
        if (modelServiceProjectionList != null && modelServiceProjectionList.size() > 0) {
            for (ServiceProjection modelServiceProjection : modelServiceProjectionList) {
                apiBusinessService = new org.uddi.api_v3.BusinessService();
                MappingModelToApi.mapBusinessService(modelServiceProjection.getBusinessService(), apiBusinessService);
                apiBusinessServiceList.add(apiBusinessService);
            }
        }
        if (apiBusinessServiceList.size() > 0) {
            apiBusinessEntity.setBusinessServices(apiBusinessServices);
        }
    }

    public static void mapBusinessService(BusinessService modelBusinessService, org.uddi.api_v3.BusinessService apiBusinessService) throws DispositionReportFaultMessage {
        apiBusinessService.setBusinessKey(modelBusinessService.getBusinessEntity().getEntityKey());
        apiBusinessService.setServiceKey(modelBusinessService.getEntityKey());
        MappingModelToApi.mapServiceNames(modelBusinessService.getServiceNames(), apiBusinessService.getName());
        MappingModelToApi.mapServiceDescriptions(modelBusinessService.getServiceDescrs(), apiBusinessService.getDescription());
        MappingModelToApi.mapBindingTemplates(modelBusinessService.getBindingTemplates(), apiBusinessService.getBindingTemplates(), apiBusinessService);
        apiBusinessService.setCategoryBag(MappingModelToApi.mapCategoryBag(modelBusinessService.getCategoryBag(), apiBusinessService.getCategoryBag()));
    }

    public static void mapServiceNames(List<ServiceName> modelNameList, List<Name> apiNameList) throws DispositionReportFaultMessage {
        apiNameList.clear();
        for (ServiceName modelName : modelNameList) {
            Name apiName = new Name();
            apiName.setLang(modelName.getLangCode());
            apiName.setValue(modelName.getName());
            apiNameList.add(apiName);
        }
    }

    public static void mapServiceDescriptions(List<ServiceDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (ServiceDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapBindingTemplates(List<org.apache.juddi.model.BindingTemplate> modelBindingTemplateList, BindingTemplates apiBindingTemplates, org.uddi.api_v3.BusinessService apiBusinessService) throws DispositionReportFaultMessage {
        if (modelBindingTemplateList == null || modelBindingTemplateList.size() == 0) {
            return;
        }
        if (apiBindingTemplates == null) {
            apiBindingTemplates = new BindingTemplates();
        }
        List apiBindingTemplateList = apiBindingTemplates.getBindingTemplate();
        apiBindingTemplateList.clear();
        for (org.apache.juddi.model.BindingTemplate modelBindingTemplate : modelBindingTemplateList) {
            BindingTemplate apiBindingTemplate = new BindingTemplate();
            MappingModelToApi.mapBindingTemplate(modelBindingTemplate, apiBindingTemplate);
            apiBindingTemplateList.add(apiBindingTemplate);
        }
        apiBusinessService.setBindingTemplates(apiBindingTemplates);
    }

    public static void mapBindingTemplate(org.apache.juddi.model.BindingTemplate modelBindingTemplate, BindingTemplate apiBindingTemplate) throws DispositionReportFaultMessage {
        apiBindingTemplate.setServiceKey(modelBindingTemplate.getBusinessService().getEntityKey());
        apiBindingTemplate.setBindingKey(modelBindingTemplate.getEntityKey());
        AccessPoint apiAccessPoint = new AccessPoint();
        apiAccessPoint.setUseType(modelBindingTemplate.getAccessPointType());
        String accessPointValue = modelBindingTemplate.getAccessPointUrl();
        if (accessPointValue != null) {
            try {
                String baseUrl = AppConfig.getConfiguration().getString("juddi.server.baseurl");
                if (baseUrl == null) {
                    logger.warn((Object)"Token 'juddi.server.baseurl' not found in the juddiv3.properties, defaulting to 'http://localhost:8080'");
                    baseUrl = "http://localhost:8080";
                }
                accessPointValue = accessPointValue.replaceAll("\\$\\{juddi.server.baseurl\\}", baseUrl);
            }
            catch (ConfigurationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        apiAccessPoint.setValue(accessPointValue);
        apiBindingTemplate.setAccessPoint(apiAccessPoint);
        if (modelBindingTemplate.getHostingRedirector() != null) {
            HostingRedirector apiHost = new HostingRedirector();
            apiHost.setBindingKey(modelBindingTemplate.getHostingRedirector());
            apiBindingTemplate.setHostingRedirector(apiHost);
        }
        MappingModelToApi.mapTModelInstanceDetails(modelBindingTemplate.getTmodelInstanceInfos(), apiBindingTemplate.getTModelInstanceDetails(), apiBindingTemplate);
        MappingModelToApi.mapBindingDescriptions(modelBindingTemplate.getBindingDescrs(), apiBindingTemplate.getDescription());
        apiBindingTemplate.setCategoryBag(MappingModelToApi.mapCategoryBag(modelBindingTemplate.getCategoryBag(), apiBindingTemplate.getCategoryBag()));
    }

    public static void mapBindingDescriptions(List<BindingDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (BindingDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static org.uddi.api_v3.CategoryBag mapCategoryBag(CategoryBag modelCategoryBag, org.uddi.api_v3.CategoryBag apiCategoryBag) throws DispositionReportFaultMessage {
        if (modelCategoryBag != null) {
            if (apiCategoryBag == null) {
                apiCategoryBag = new org.uddi.api_v3.CategoryBag();
            }
            for (org.apache.juddi.model.KeyedReference modelKeyedReference : modelCategoryBag.getKeyedReferences()) {
                KeyedReference apiKeyedReference = new KeyedReference();
                apiKeyedReference.setTModelKey(modelKeyedReference.getTmodelKeyRef());
                apiKeyedReference.setKeyName(modelKeyedReference.getKeyName());
                apiKeyedReference.setKeyValue(modelKeyedReference.getKeyValue());
                apiCategoryBag.getKeyedReference().add(apiKeyedReference);
            }
            for (org.apache.juddi.model.KeyedReferenceGroup modelKeyedReferenceGroup : modelCategoryBag.getKeyedReferenceGroups()) {
                KeyedReferenceGroup apiKeyedReferenceGroup = new KeyedReferenceGroup();
                MappingModelToApi.mapKeyedReferenceGroup(modelKeyedReferenceGroup, apiKeyedReferenceGroup);
                apiCategoryBag.getKeyedReferenceGroup().add(apiKeyedReferenceGroup);
            }
        }
        return apiCategoryBag;
    }

    public static void mapKeyedReferenceGroup(org.apache.juddi.model.KeyedReferenceGroup modelKeyedReferenceGroup, KeyedReferenceGroup apiKeyedReferenceGroup) throws DispositionReportFaultMessage {
        apiKeyedReferenceGroup.setTModelKey(modelKeyedReferenceGroup.getTmodelKey());
        for (org.apache.juddi.model.KeyedReference modelKeyedReference : modelKeyedReferenceGroup.getKeyedReferences()) {
            KeyedReference apiKeyedReference = new KeyedReference();
            apiKeyedReference.setTModelKey(modelKeyedReference.getTmodelKeyRef());
            apiKeyedReference.setKeyName(modelKeyedReference.getKeyName());
            apiKeyedReference.setKeyValue(modelKeyedReference.getKeyValue());
            apiKeyedReferenceGroup.getKeyedReference().add(apiKeyedReference);
        }
    }

    public static void mapTModelInstanceDetails(List<TmodelInstanceInfo> modelTModelInstInfoList, TModelInstanceDetails apiTModelInstDetails, BindingTemplate apiBindingTemplate) throws DispositionReportFaultMessage {
        if (modelTModelInstInfoList == null || modelTModelInstInfoList.size() == 0) {
            return;
        }
        if (apiTModelInstDetails == null) {
            apiTModelInstDetails = new TModelInstanceDetails();
        }
        List apiTModelInstInfoList = apiTModelInstDetails.getTModelInstanceInfo();
        apiTModelInstInfoList.clear();
        for (TmodelInstanceInfo modelTModelInstInfo : modelTModelInstInfoList) {
            TModelInstanceInfo apiTModelInstInfo = new TModelInstanceInfo();
            apiTModelInstInfo.setTModelKey(modelTModelInstInfo.getTmodelKey());
            MappingModelToApi.mapTModelInstanceInfoDescriptions(modelTModelInstInfo.getTmodelInstanceInfoDescrs(), apiTModelInstInfo.getDescription());
            MappingModelToApi.mapInstanceDetails(modelTModelInstInfo, apiTModelInstInfo.getInstanceDetails(), apiTModelInstInfo);
            apiTModelInstInfoList.add(apiTModelInstInfo);
        }
        apiBindingTemplate.setTModelInstanceDetails(apiTModelInstDetails);
    }

    public static void mapTModelInstanceInfoDescriptions(List<TmodelInstanceInfoDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (TmodelInstanceInfoDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapInstanceDetails(TmodelInstanceInfo modelTModelInstInfo, InstanceDetails apiInstanceDetails, TModelInstanceInfo apiTModelInstInfo) throws DispositionReportFaultMessage {
        if (modelTModelInstInfo == null || modelTModelInstInfo.getInstanceParms() == null && modelTModelInstInfo.getOverviewDocs().size() == 0) {
            return;
        }
        if (apiInstanceDetails == null) {
            apiInstanceDetails = new InstanceDetails();
        }
        apiInstanceDetails.setInstanceParms(modelTModelInstInfo.getInstanceParms());
        List<InstanceDetailsDescr> modelInstDetailsDescrList = modelTModelInstInfo.getInstanceDetailsDescrs();
        for (InstanceDetailsDescr modelInstDetailDescr : modelInstDetailsDescrList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelInstDetailDescr.getLangCode());
            apiDesc.setValue(modelInstDetailDescr.getDescr());
            apiInstanceDetails.getDescription().add(apiDesc);
        }
        MappingModelToApi.mapOverviewDocs(modelTModelInstInfo.getOverviewDocs(), apiInstanceDetails, null);
        apiTModelInstInfo.setInstanceDetails(apiInstanceDetails);
    }

    public static void mapOverviewDocs(List<OverviewDoc> modelOverviewDocs, InstanceDetails apiInstanceDetails, TModel apiTModel) {
        for (OverviewDoc modelOverviewDoc : modelOverviewDocs) {
            org.uddi.api_v3.OverviewDoc apiOverviewDoc = new org.uddi.api_v3.OverviewDoc();
            List<OverviewDocDescr> overviewDocDescrList = modelOverviewDoc.getOverviewDocDescrs();
            for (OverviewDocDescr overviewDocDescr : overviewDocDescrList) {
                Description apiDesc = new Description();
                apiDesc.setLang(overviewDocDescr.getLangCode());
                apiDesc.setValue(overviewDocDescr.getDescr());
                apiOverviewDoc.getDescription().add(apiDesc);
            }
            OverviewURL apiOverviewURL = new OverviewURL();
            apiOverviewURL.setUseType(modelOverviewDoc.getOverviewUrlUseType());
            apiOverviewURL.setValue(modelOverviewDoc.getOverviewUrl());
            apiOverviewDoc.setOverviewURL(apiOverviewURL);
            if (apiInstanceDetails != null) {
                apiInstanceDetails.getOverviewDoc().add(apiOverviewDoc);
                continue;
            }
            apiTModel.getOverviewDoc().add(apiOverviewDoc);
        }
    }

    public static void mapTModel(Tmodel modelTModel, TModel apiTModel) throws DispositionReportFaultMessage {
        apiTModel.setTModelKey(modelTModel.getEntityKey());
        Name apiName = new Name();
        apiName.setValue(modelTModel.getName());
        apiTModel.setName(apiName);
        apiTModel.setDeleted(Boolean.valueOf(modelTModel.getDeleted()));
        MappingModelToApi.mapTModelDescriptions(modelTModel.getTmodelDescrs(), apiTModel.getDescription());
        MappingModelToApi.mapTModelIdentifiers(modelTModel.getTmodelIdentifiers(), apiTModel.getIdentifierBag(), apiTModel);
        apiTModel.setCategoryBag(MappingModelToApi.mapCategoryBag(modelTModel.getCategoryBag(), apiTModel.getCategoryBag()));
        MappingModelToApi.mapOverviewDocs(modelTModel.getOverviewDocs(), null, apiTModel);
    }

    public static void mapTModelDescriptions(List<TmodelDescr> modelDescList, List<Description> apiDescList) throws DispositionReportFaultMessage {
        apiDescList.clear();
        for (TmodelDescr modelDesc : modelDescList) {
            Description apiDesc = new Description();
            apiDesc.setLang(modelDesc.getLangCode());
            apiDesc.setValue(modelDesc.getDescr());
            apiDescList.add(apiDesc);
        }
    }

    public static void mapTModelIdentifiers(List<TmodelIdentifier> modelIdentifierList, IdentifierBag apiIdentifierBag, TModel apiTModel) throws DispositionReportFaultMessage {
        if (modelIdentifierList == null || modelIdentifierList.size() == 0) {
            return;
        }
        if (apiIdentifierBag == null) {
            apiIdentifierBag = new IdentifierBag();
        }
        List apiKeyedRefList = apiIdentifierBag.getKeyedReference();
        apiKeyedRefList.clear();
        for (TmodelIdentifier modelIdentifier : modelIdentifierList) {
            KeyedReference apiKeyedRef = new KeyedReference();
            apiKeyedRef.setTModelKey(modelIdentifier.getTmodelKeyRef());
            apiKeyedRef.setKeyName(modelIdentifier.getKeyName());
            apiKeyedRef.setKeyValue(modelIdentifier.getKeyValue());
            apiKeyedRefList.add(apiKeyedRef);
        }
        apiTModel.setIdentifierBag(apiIdentifierBag);
    }

    public static void mapBusinessInfo(org.apache.juddi.model.BusinessEntity modelBusinessEntity, BusinessInfo apiBusinessInfo) throws DispositionReportFaultMessage {
        apiBusinessInfo.setBusinessKey(modelBusinessEntity.getEntityKey());
        MappingModelToApi.mapBusinessNames(modelBusinessEntity.getBusinessNames(), apiBusinessInfo.getName());
        MappingModelToApi.mapBusinessDescriptions(modelBusinessEntity.getBusinessDescrs(), apiBusinessInfo.getDescription());
        MappingModelToApi.mapServiceInfos(modelBusinessEntity.getBusinessServices(), apiBusinessInfo.getServiceInfos(), apiBusinessInfo);
    }

    public static void mapServiceInfos(List<BusinessService> modelBusinessServiceList, ServiceInfos apiServiceInfos, BusinessInfo apiBusinessInfo) throws DispositionReportFaultMessage {
        if (modelBusinessServiceList.size() == 0) {
            return;
        }
        if (apiServiceInfos == null) {
            apiServiceInfos = new ServiceInfos();
        }
        List apiServiceInfoList = apiServiceInfos.getServiceInfo();
        apiServiceInfoList.clear();
        for (BusinessService modelBusinessService : modelBusinessServiceList) {
            ServiceInfo apiServiceInfo = new ServiceInfo();
            MappingModelToApi.mapServiceInfo(modelBusinessService, apiServiceInfo);
            apiServiceInfos.getServiceInfo().add(apiServiceInfo);
        }
        apiBusinessInfo.setServiceInfos(apiServiceInfos);
    }

    public static void mapServiceInfo(BusinessService modelBusinessService, ServiceInfo apiServiceInfo) throws DispositionReportFaultMessage {
        apiServiceInfo.setBusinessKey(modelBusinessService.getBusinessEntity().getEntityKey());
        apiServiceInfo.setServiceKey(modelBusinessService.getEntityKey());
        MappingModelToApi.mapServiceNames(modelBusinessService.getServiceNames(), apiServiceInfo.getName());
    }

    public static void mapTModelInfo(Tmodel modelTModel, TModelInfo apiTModelInfo) throws DispositionReportFaultMessage {
        apiTModelInfo.setTModelKey(modelTModel.getEntityKey());
        Name apiName = new Name();
        apiName.setValue(modelTModel.getName());
        apiTModelInfo.setName(apiName);
        MappingModelToApi.mapTModelDescriptions(modelTModel.getTmodelDescrs(), apiTModelInfo.getDescription());
    }

    public static void mapAuthToken(org.apache.juddi.model.AuthToken modelAuthToken, AuthToken apiAuthToken) throws DispositionReportFaultMessage {
        apiAuthToken.setAuthInfo(modelAuthToken.getAuthToken());
    }

    public static void mapPublisherAssertion(org.apache.juddi.model.PublisherAssertion modelPublisherAssertion, PublisherAssertion apiPublisherAssertion) throws DispositionReportFaultMessage {
        apiPublisherAssertion.setFromKey(modelPublisherAssertion.getId().getFromKey());
        apiPublisherAssertion.setToKey(modelPublisherAssertion.getId().getToKey());
        KeyedReference keyedRef = new KeyedReference();
        keyedRef.setTModelKey(modelPublisherAssertion.getTmodelKey());
        keyedRef.setKeyName(modelPublisherAssertion.getKeyName());
        keyedRef.setKeyValue(modelPublisherAssertion.getKeyValue());
        apiPublisherAssertion.setKeyedReference(keyedRef);
    }

    public static void mapAssertionStatusItem(org.apache.juddi.model.PublisherAssertion modelPublisherAssertion, AssertionStatusItem apiAssertionStatusItem, List<?> businessKeys) throws DispositionReportFaultMessage {
        apiAssertionStatusItem.setFromKey(modelPublisherAssertion.getId().getFromKey());
        apiAssertionStatusItem.setToKey(modelPublisherAssertion.getId().getToKey());
        KeyedReference keyedRef = new KeyedReference();
        keyedRef.setTModelKey(modelPublisherAssertion.getTmodelKey());
        keyedRef.setKeyName(modelPublisherAssertion.getKeyName());
        keyedRef.setKeyValue(modelPublisherAssertion.getKeyValue());
        apiAssertionStatusItem.setKeyedReference(keyedRef);
        if ("true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) && "true".equalsIgnoreCase(modelPublisherAssertion.getToCheck())) {
            apiAssertionStatusItem.setCompletionStatus(CompletionStatus.STATUS_COMPLETE);
        } else if (!"true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) && "true".equalsIgnoreCase(modelPublisherAssertion.getToCheck())) {
            apiAssertionStatusItem.setCompletionStatus(CompletionStatus.STATUS_FROM_KEY_INCOMPLETE);
        } else if ("true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) && !"true".equalsIgnoreCase(modelPublisherAssertion.getToCheck())) {
            apiAssertionStatusItem.setCompletionStatus(CompletionStatus.STATUS_TO_KEY_INCOMPLETE);
        } else if (!"true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) && !"true".equalsIgnoreCase(modelPublisherAssertion.getToCheck())) {
            apiAssertionStatusItem.setCompletionStatus(CompletionStatus.STATUS_BOTH_INCOMPLETE);
        }
        KeysOwned keysOwned = new KeysOwned();
        Collections.sort(businessKeys);
        if (Collections.binarySearch(businessKeys, modelPublisherAssertion.getBusinessEntityByFromKey().getEntityKey()) >= 0) {
            keysOwned.setFromKey(modelPublisherAssertion.getBusinessEntityByFromKey().getEntityKey());
        }
        if (Collections.binarySearch(businessKeys, modelPublisherAssertion.getBusinessEntityByToKey().getEntityKey()) >= 0) {
            keysOwned.setToKey(modelPublisherAssertion.getBusinessEntityByToKey().getEntityKey());
        }
        if (keysOwned.getFromKey() == null && keysOwned.getToKey() == null) {
            throw new FatalErrorException(new ErrorMessage("errors.invalidKey.KeysOwned"));
        }
    }

    public static void mapRelatedBusinessInfo(org.apache.juddi.model.PublisherAssertion modelPublisherAssertion, org.apache.juddi.model.BusinessEntity modelRelatedBusiness, Direction direction, RelatedBusinessInfo apiRelatedBusinessInfo) throws DispositionReportFaultMessage {
        apiRelatedBusinessInfo.setBusinessKey(modelRelatedBusiness.getEntityKey());
        MappingModelToApi.mapBusinessNames(modelRelatedBusiness.getBusinessNames(), apiRelatedBusinessInfo.getName());
        MappingModelToApi.mapBusinessDescriptions(modelRelatedBusiness.getBusinessDescrs(), apiRelatedBusinessInfo.getDescription());
        SharedRelationships sharedRelationships = new SharedRelationships();
        sharedRelationships.setDirection(direction);
        KeyedReference keyedRef = new KeyedReference();
        keyedRef.setTModelKey(modelPublisherAssertion.getTmodelKey());
        keyedRef.setKeyName(modelPublisherAssertion.getKeyName());
        keyedRef.setKeyValue(modelPublisherAssertion.getKeyValue());
        sharedRelationships.getKeyedReference().add(keyedRef);
        apiRelatedBusinessInfo.getSharedRelationships().add(sharedRelationships);
    }

    public static void mapOperationalInfo(UddiEntity modelUddiEntity, OperationalInfo apiOperationalInfo) throws DispositionReportFaultMessage {
        apiOperationalInfo.setCreated(TypeConvertor.convertDateToXMLGregorianCalendar(modelUddiEntity.getCreated()));
        apiOperationalInfo.setModified(TypeConvertor.convertDateToXMLGregorianCalendar(modelUddiEntity.getModified()));
        apiOperationalInfo.setModifiedIncludingChildren(TypeConvertor.convertDateToXMLGregorianCalendar(modelUddiEntity.getModifiedIncludingChildren()));
        apiOperationalInfo.setNodeID(modelUddiEntity.getNodeId());
        apiOperationalInfo.setAuthorizedName(modelUddiEntity.getAuthorizedName());
        apiOperationalInfo.setEntityKey(modelUddiEntity.getEntityKey());
    }

    public static void mapSubscription(org.apache.juddi.model.Subscription modelSubscription, Subscription apiSubscription) throws DispositionReportFaultMessage {
        apiSubscription.setSubscriptionKey(modelSubscription.getSubscriptionKey());
        apiSubscription.setBrief(modelSubscription.isBrief());
        apiSubscription.setExpiresAfter(TypeConvertor.convertDateToXMLGregorianCalendar(modelSubscription.getExpiresAfter()));
        apiSubscription.setBindingKey(modelSubscription.getBindingKey());
        apiSubscription.setMaxEntities(modelSubscription.getMaxEntities());
        apiSubscription.setNotificationInterval(TypeConvertor.convertStringToDuration(modelSubscription.getNotificationInterval()));
        try {
            SubscriptionFilter existingFilter = (SubscriptionFilter)JAXBMarshaller.unmarshallFromString((String)modelSubscription.getSubscriptionFilter(), (String)"org.uddi.sub_v3");
            apiSubscription.setSubscriptionFilter(existingFilter);
        }
        catch (JAXBException e) {
            logger.error((Object)"JAXB Exception while marshalling subscription filter", (Throwable)e);
            throw new FatalErrorException(new ErrorMessage("errors.Unspecified"));
        }
    }

    public static void mapClientSubscriptionInfo(ClientSubscriptionInfo modelClientSubscriptionInfo, org.apache.juddi.api_v3.ClientSubscriptionInfo apiClientSubscriptionInfo) throws DispositionReportFaultMessage {
        apiClientSubscriptionInfo.setSubscriptionKey(modelClientSubscriptionInfo.getSubscriptionKey());
        apiClientSubscriptionInfo.setLastModified(modelClientSubscriptionInfo.getLastNotified());
        if (modelClientSubscriptionInfo.getFromClerk() != null) {
            org.apache.juddi.api_v3.Clerk apiFromClerk = new org.apache.juddi.api_v3.Clerk();
            MappingModelToApi.mapClerk(modelClientSubscriptionInfo.getFromClerk(), apiFromClerk);
            apiClientSubscriptionInfo.setFromClerk(apiFromClerk);
        }
        if (modelClientSubscriptionInfo.getToClerk() != null) {
            org.apache.juddi.api_v3.Clerk apiToClerk = new org.apache.juddi.api_v3.Clerk();
            MappingModelToApi.mapClerk(modelClientSubscriptionInfo.getToClerk(), apiToClerk);
            apiClientSubscriptionInfo.setToClerk(apiToClerk);
        }
    }

    public static void mapClerk(Clerk modelClerk, org.apache.juddi.api_v3.Clerk apiClerk) throws DispositionReportFaultMessage {
        apiClerk.setName(modelClerk.getClerkName());
        apiClerk.setPassword(modelClerk.getCred());
        apiClerk.setPublisher(modelClerk.getPublisherId());
        if (modelClerk.getNode() != null) {
            org.apache.juddi.api_v3.Node apiNode = new org.apache.juddi.api_v3.Node();
            MappingModelToApi.mapNode(modelClerk.getNode(), apiNode);
            apiClerk.setNode(apiNode);
        }
    }

    public static void mapNode(Node modelNode, org.apache.juddi.api_v3.Node apiNode) throws DispositionReportFaultMessage {
        apiNode.setCustodyTransferUrl(modelNode.getCustodyTransferUrl());
        apiNode.setFactoryInitial(modelNode.getFactoryInitial());
        apiNode.setFactoryNamingProvider(modelNode.getFactoryNamingProvider());
        apiNode.setFactoryURLPkgs(modelNode.getFactoryURLPkgs());
        apiNode.setInquiryUrl(modelNode.getInquiryUrl());
        apiNode.setJuddiApiUrl(modelNode.getJuddiApiUrl());
        apiNode.setName(modelNode.getName());
        apiNode.setManagerName(modelNode.getManagerName());
        apiNode.setProxyTransport(modelNode.getProxyTransport());
        apiNode.setPublishUrl(modelNode.getPublishUrl());
        apiNode.setSecurityUrl(modelNode.getSecurityUrl());
        apiNode.setSubscriptionUrl(modelNode.getSubscriptionUrl());
    }
}

