/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.keygen;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.keygen.KeyGenerator;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.Loader;

public abstract class KeyGeneratorFactory {
    private static Logger log = Logger.getLogger(KeyGeneratorFactory.class);
    private static final String DEFAULT_IMPL = "org.apache.juddi.keygen.DefaultKeyGenerator";
    private static KeyGenerator keyGenerator = null;

    public static KeyGenerator getKeyGenerator() {
        if (keyGenerator == null) {
            keyGenerator = KeyGeneratorFactory.createKeyGenerator();
        }
        return keyGenerator;
    }

    private static synchronized KeyGenerator createKeyGenerator() {
        if (keyGenerator != null) {
            return keyGenerator;
        }
        String className = DEFAULT_IMPL;
        try {
            className = AppConfig.getConfiguration().getString("juddi.keygenerator", DEFAULT_IMPL);
        }
        catch (ConfigurationException ce) {
            log.error((Object)"Configuration exception occurred retrieving: juddi.keygenerator");
        }
        log.debug((Object)("Key Generator Implementation = " + className));
        Class keygenClass = null;
        try {
            keygenClass = Loader.loadClass((String)className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified Key Generator class '" + className + "' was not found in classpath."));
            log.error((Object)e);
        }
        try {
            keyGenerator = (KeyGenerator)keygenClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Exception while attempting to instantiate the implementation of Key Generator: " + keygenClass.getName() + "\n" + e.getMessage()));
            log.error((Object)e);
        }
        return keyGenerator;
    }
}

