/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.config;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.config.AppConfig;
import org.apache.log4j.Logger;

public class PersistenceManager {
    private static Logger log = Logger.getLogger(PersistenceManager.class);
    public static final String PERSISTENCE_UNIT_NAME = "juddiDatabase";
    private static EntityManagerFactory emf;

    public static EntityManager getEntityManager() {
        try {
            if (emf == null) {
                AppConfig.getInstance();
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)"Error initializing config in PersistenceManager", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        return emf.createEntityManager();
    }

    public static void closeEntityManager() {
        if (emf.isOpen()) {
            emf.close();
        }
    }

    protected static void initializeEntityManagerFactory(String persistenceUnitName) {
        try {
            if (emf == null) {
                emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
            }
        }
        catch (Throwable t) {
            log.error((Object)"entityManagerFactory creation failed", t);
            throw new ExceptionInInitializerError(t);
        }
    }
}

