/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.xml.ws.Holder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.api.impl.AuthenticatedService;
import org.apache.juddi.api.impl.PublicationHelper;
import org.apache.juddi.config.AppConfig;
import org.apache.juddi.config.PersistenceManager;
import org.apache.juddi.mapping.MappingApiToModel;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.model.PublisherAssertionId;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.query.DeletePublisherAssertionByBusinessQuery;
import org.apache.juddi.query.FetchBusinessEntitiesQuery;
import org.apache.juddi.query.FetchTModelsQuery;
import org.apache.juddi.query.FindBusinessByPublisherQuery;
import org.apache.juddi.query.FindPublisherAssertionByBusinessQuery;
import org.apache.juddi.query.FindTModelByPublisherQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.FatalErrorException;
import org.apache.juddi.v3.error.RegistryException;
import org.apache.juddi.v3.error.UDDIErrorHelper;
import org.apache.juddi.validation.ValidatePublish;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.InfoSelection;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIPublicationPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="UDDIPublicationService", endpointInterface="org.uddi.v3_service.UDDIPublicationPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDIPublicationImpl
extends AuthenticatedService
implements UDDIPublicationPortType {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispositionReport addPublisherAssertions(AddPublisherAssertions body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateAddPublisherAssertions(em, body);
            List apiPubAssertionList = body.getPublisherAssertion();
            for (org.uddi.api_v3.PublisherAssertion apiPubAssertion : apiPubAssertionList) {
                PublisherAssertion modelPubAssertion = new PublisherAssertion();
                MappingApiToModel.mapPublisherAssertion(apiPubAssertion, modelPubAssertion);
                PublisherAssertion existingPubAssertion = (PublisherAssertion)em.find(modelPubAssertion.getClass(), (Object)modelPubAssertion.getId());
                boolean persistNewAssertion = true;
                if (existingPubAssertion != null) {
                    if (modelPubAssertion.getTmodelKey().equalsIgnoreCase(existingPubAssertion.getTmodelKey()) && modelPubAssertion.getKeyName().equalsIgnoreCase(existingPubAssertion.getKeyName()) && modelPubAssertion.getKeyValue().equalsIgnoreCase(existingPubAssertion.getKeyValue())) {
                        if (publisher.isOwner(existingPubAssertion.getBusinessEntityByFromKey())) {
                            existingPubAssertion.setFromCheck("true");
                        }
                        if (publisher.isOwner(existingPubAssertion.getBusinessEntityByToKey())) {
                            existingPubAssertion.setToCheck("true");
                        }
                        persistNewAssertion = false;
                    } else {
                        em.remove((Object)existingPubAssertion);
                    }
                }
                if (!persistNewAssertion) continue;
                BusinessEntity beFrom = (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPubAssertion.getId().getFromKey());
                BusinessEntity beTo = (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPubAssertion.getId().getToKey());
                modelPubAssertion.setBusinessEntityByFromKey(beFrom);
                modelPubAssertion.setBusinessEntityByToKey(beTo);
                modelPubAssertion.setFromCheck("false");
                modelPubAssertion.setToCheck("false");
                em.persist((Object)modelPubAssertion);
                if (publisher.isOwner(modelPubAssertion.getBusinessEntityByFromKey())) {
                    modelPubAssertion.setFromCheck("true");
                }
                if (!publisher.isOwner(modelPubAssertion.getBusinessEntityByToKey())) continue;
                modelPubAssertion.setToCheck("true");
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return UDDIErrorHelper.buildDispositionReport(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispositionReport deleteBinding(DeleteBinding body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteBinding(em, body);
            List entityKeyList = body.getBindingKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(BindingTemplate.class, (Object)entityKey);
                ((BindingTemplate)obj).getBusinessService().setModifiedIncludingChildren(new Date());
                em.remove(obj);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return UDDIErrorHelper.buildDispositionReport(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispositionReport deleteBusiness(DeleteBusiness body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteBusiness(em, body);
            List entityKeyList = body.getBusinessKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(BusinessEntity.class, (Object)entityKey);
                em.remove(obj);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return UDDIErrorHelper.buildDispositionReport(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispositionReport deletePublisherAssertions(DeletePublisherAssertions body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeletePublisherAssertions(em, body);
            List entityList = body.getPublisherAssertion();
            for (org.uddi.api_v3.PublisherAssertion entity : entityList) {
                PublisherAssertionId pubAssertionId = new PublisherAssertionId(entity.getFromKey(), entity.getToKey());
                Object obj = em.find(PublisherAssertion.class, (Object)pubAssertionId);
                em.remove(obj);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return UDDIErrorHelper.buildDispositionReport(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispositionReport deleteService(DeleteService body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteService(em, body);
            List entityKeyList = body.getServiceKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(BusinessService.class, (Object)entityKey);
                ((BusinessService)obj).getBusinessEntity().setModifiedIncludingChildren(new Date());
                em.remove(obj);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return UDDIErrorHelper.buildDispositionReport(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispositionReport deleteTModel(DeleteTModel body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateDeleteTModel(em, body);
            List entityKeyList = body.getTModelKey();
            for (String entityKey : entityKeyList) {
                Object obj = em.find(Tmodel.class, (Object)entityKey);
                ((Tmodel)obj).setDeleted(true);
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        return UDDIErrorHelper.buildDispositionReport(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AssertionStatusItem> getAssertionStatusReport(String authInfo, CompletionStatus completionStatus) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            List<AssertionStatusItem> result = PublicationHelper.getAssertionStatusItemList(publisher, completionStatus, em);
            tx.commit();
            List<AssertionStatusItem> list = result;
            return list;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<org.uddi.api_v3.PublisherAssertion> getPublisherAssertions(String authInfo) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            ArrayList<org.uddi.api_v3.PublisherAssertion> result = new ArrayList<org.uddi.api_v3.PublisherAssertion>(0);
            List<?> businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select(em, null, publisher, businessKeysFound);
            List<PublisherAssertion> pubAssertionList = FindPublisherAssertionByBusinessQuery.select(em, businessKeysFound, null);
            for (PublisherAssertion modelPubAssertion : pubAssertionList) {
                org.uddi.api_v3.PublisherAssertion apiPubAssertion = new org.uddi.api_v3.PublisherAssertion();
                MappingModelToApi.mapPublisherAssertion(modelPubAssertion, apiPubAssertion);
                result.add(apiPubAssertion);
            }
            tx.commit();
            ArrayList<org.uddi.api_v3.PublisherAssertion> arrayList = result;
            return arrayList;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredInfo getRegisteredInfo(GetRegisteredInfo body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateRegisteredInfo(body);
            List<?> businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select(em, null, publisher, businessKeysFound);
            List<?> tmodelKeysFound = null;
            tmodelKeysFound = body.getInfoSelection().equals((Object)InfoSelection.HIDDEN) ? FindTModelByPublisherQuery.select(em, null, publisher, tmodelKeysFound, new DynamicQuery.Parameter("t.deleted", new Boolean(true), DynamicQuery.PREDICATE_EQUALS)) : (body.getInfoSelection().equals((Object)InfoSelection.VISIBLE) ? FindTModelByPublisherQuery.select(em, null, publisher, tmodelKeysFound, new DynamicQuery.Parameter("t.deleted", new Boolean(false), DynamicQuery.PREDICATE_EQUALS)) : FindTModelByPublisherQuery.select(em, null, publisher, tmodelKeysFound, new DynamicQuery.Parameter[0]));
            RegisteredInfo result = new RegisteredInfo();
            List<?> queryResults = FetchBusinessEntitiesQuery.select(em, new FindQualifiers(), businessKeysFound, null, null, null, new DynamicQuery.Parameter[0]);
            result.setBusinessInfos(new BusinessInfos());
            for (Object item : queryResults) {
                BusinessEntity modelBusinessEntity = (BusinessEntity)item;
                BusinessInfo apiBusinessInfo = new BusinessInfo();
                MappingModelToApi.mapBusinessInfo(modelBusinessEntity, apiBusinessInfo);
                result.getBusinessInfos().getBusinessInfo().add(apiBusinessInfo);
            }
            queryResults = FetchTModelsQuery.select(em, new FindQualifiers(), tmodelKeysFound, null, null, null, new DynamicQuery.Parameter[0]);
            result.setTModelInfos(new TModelInfos());
            for (Object item : queryResults) {
                Tmodel modelTModel = (Tmodel)item;
                TModelInfo apiTModelInfo = new TModelInfo();
                MappingModelToApi.mapTModelInfo(modelTModel, apiTModelInfo);
                result.getTModelInfos().getTModelInfo().add(apiTModelInfo);
            }
            tx.commit();
            RegisteredInfo registeredInfo = result;
            return registeredInfo;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    public BindingDetail saveBinding(SaveBinding body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSaveBinding(em, body, null);
            BindingDetail result = new BindingDetail();
            List apiBindingTemplateList = body.getBindingTemplate();
            for (org.uddi.api_v3.BindingTemplate apiBindingTemplate : apiBindingTemplateList) {
                BindingTemplate modelBindingTemplate = new BindingTemplate();
                BusinessService modelBusinessService = new BusinessService();
                modelBusinessService.setEntityKey(apiBindingTemplate.getServiceKey());
                MappingApiToModel.mapBindingTemplate(apiBindingTemplate, modelBindingTemplate, modelBusinessService);
                this.setOperationalInfo(em, modelBindingTemplate, publisher, false);
                em.persist((Object)modelBindingTemplate);
                result.getBindingTemplate().add(apiBindingTemplate);
            }
            tx.commit();
            BindingDetail bindingDetail = result;
            return bindingDetail;
        }
        catch (RegistryException e) {
            throw e;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessDetail saveBusiness(SaveBusiness body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSaveBusiness(em, body, null);
            BusinessDetail result = new BusinessDetail();
            List apiBusinessEntityList = body.getBusinessEntity();
            for (org.uddi.api_v3.BusinessEntity apiBusinessEntity : apiBusinessEntityList) {
                BusinessEntity modelBusinessEntity = new BusinessEntity();
                MappingApiToModel.mapBusinessEntity(apiBusinessEntity, modelBusinessEntity);
                this.setOperationalInfo(em, modelBusinessEntity, publisher);
                em.persist((Object)modelBusinessEntity);
                result.getBusinessEntity().add(apiBusinessEntity);
            }
            tx.commit();
            BusinessDetail businessDetail = result;
            return businessDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDetail saveService(SaveService body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSaveService(em, body, null);
            ServiceDetail result = new ServiceDetail();
            List apiBusinessServiceList = body.getBusinessService();
            for (org.uddi.api_v3.BusinessService apiBusinessService : apiBusinessServiceList) {
                BusinessService modelBusinessService = new BusinessService();
                BusinessEntity modelBusinessEntity = new BusinessEntity();
                modelBusinessEntity.setEntityKey(apiBusinessService.getBusinessKey());
                MappingApiToModel.mapBusinessService(apiBusinessService, modelBusinessService, modelBusinessEntity);
                this.setOperationalInfo(em, modelBusinessService, publisher, false);
                em.persist((Object)modelBusinessService);
                result.getBusinessService().add(apiBusinessService);
            }
            tx.commit();
            ServiceDetail serviceDetail = result;
            return serviceDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TModelDetail saveTModel(SaveTModel body) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, body.getAuthInfo());
            new ValidatePublish(publisher).validateSaveTModel(em, body, null);
            TModelDetail result = new TModelDetail();
            List apiTModelList = body.getTModel();
            for (TModel apiTModel : apiTModelList) {
                Tmodel modelTModel = new Tmodel();
                MappingApiToModel.mapTModel(apiTModel, modelTModel);
                this.setOperationalInfo(em, modelTModel, publisher);
                em.persist((Object)modelTModel);
                result.getTModel().add(apiTModel);
            }
            tx.commit();
            TModelDetail tModelDetail = result;
            return tModelDetail;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublisherAssertions(String authInfo, Holder<List<org.uddi.api_v3.PublisherAssertion>> publisherAssertion) throws DispositionReportFaultMessage {
        EntityManager em = PersistenceManager.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            UddiEntityPublisher publisher = this.getEntityPublisher(em, authInfo);
            new ValidatePublish(publisher).validateSetPublisherAssertions(em, publisherAssertion);
            List<?> businessKeysFound = null;
            businessKeysFound = FindBusinessByPublisherQuery.select(em, null, publisher, businessKeysFound);
            DeletePublisherAssertionByBusinessQuery.delete(em, businessKeysFound);
            List apiPubAssertionList = (List)publisherAssertion.value;
            for (org.uddi.api_v3.PublisherAssertion apiPubAssertion : apiPubAssertionList) {
                PublisherAssertion modelPubAssertion = new PublisherAssertion();
                MappingApiToModel.mapPublisherAssertion(apiPubAssertion, modelPubAssertion);
                BusinessEntity beFrom = (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPubAssertion.getId().getFromKey());
                BusinessEntity beTo = (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPubAssertion.getId().getToKey());
                modelPubAssertion.setBusinessEntityByFromKey(beFrom);
                modelPubAssertion.setBusinessEntityByToKey(beTo);
                modelPubAssertion.setFromCheck("false");
                modelPubAssertion.setToCheck("false");
                em.persist((Object)modelPubAssertion);
                if (publisher.isOwner(modelPubAssertion.getBusinessEntityByFromKey())) {
                    modelPubAssertion.setFromCheck("true");
                }
                if (!publisher.isOwner(modelPubAssertion.getBusinessEntityByToKey())) continue;
                modelPubAssertion.setToCheck("true");
            }
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }

    private void setOperationalInfo(EntityManager em, BusinessEntity uddiEntity, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        BusinessEntity existingUddiEntity = (BusinessEntity)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        List<BusinessService> serviceList = uddiEntity.getBusinessServices();
        for (BusinessService service : serviceList) {
            this.setOperationalInfo(em, service, publisher, true);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, BusinessService uddiEntity, UddiEntityPublisher publisher, boolean isChild) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        if (!isChild) {
            BusinessEntity parent = (BusinessEntity)em.find(BusinessEntity.class, (Object)uddiEntity.getBusinessEntity().getEntityKey());
            parent.setModifiedIncludingChildren(now);
            em.persist((Object)parent);
        }
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        BusinessService existingUddiEntity = (BusinessService)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        List<BindingTemplate> bindingList = uddiEntity.getBindingTemplates();
        for (BindingTemplate binding : bindingList) {
            this.setOperationalInfo(em, binding, publisher, true);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, BindingTemplate uddiEntity, UddiEntityPublisher publisher, boolean isChild) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        if (!isChild) {
            BusinessService parent = (BusinessService)em.find(BusinessService.class, (Object)uddiEntity.getBusinessService().getEntityKey());
            parent.setModifiedIncludingChildren(now);
            em.persist((Object)parent);
        }
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        BindingTemplate existingUddiEntity = (BindingTemplate)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }

    private void setOperationalInfo(EntityManager em, Tmodel uddiEntity, UddiEntityPublisher publisher) throws DispositionReportFaultMessage {
        uddiEntity.setAuthorizedName(publisher.getAuthorizedName());
        Date now = new Date();
        uddiEntity.setModified(now);
        uddiEntity.setModifiedIncludingChildren(now);
        String nodeId = "";
        try {
            nodeId = AppConfig.getConfiguration().getString("juddi.nodeId");
        }
        catch (ConfigurationException ce) {
            throw new FatalErrorException(new ErrorMessage("errors.configuration.Retrieval", "juddi.nodeId"));
        }
        uddiEntity.setNodeId(nodeId);
        Tmodel existingUddiEntity = (Tmodel)em.find(uddiEntity.getClass(), (Object)uddiEntity.getEntityKey());
        if (existingUddiEntity != null) {
            uddiEntity.setCreated(existingUddiEntity.getCreated());
        } else {
            uddiEntity.setCreated(now);
        }
        if (existingUddiEntity != null) {
            em.remove((Object)existingUddiEntity);
        }
    }
}

