/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.ws.Holder;
import org.apache.juddi.mapping.MappingModelToApi;
import org.apache.juddi.model.BindingTemplate;
import org.apache.juddi.model.BusinessEntity;
import org.apache.juddi.model.BusinessService;
import org.apache.juddi.model.PublisherAssertion;
import org.apache.juddi.model.Tmodel;
import org.apache.juddi.query.FetchBindingTemplatesQuery;
import org.apache.juddi.query.FetchBusinessEntitiesQuery;
import org.apache.juddi.query.FetchBusinessServicesQuery;
import org.apache.juddi.query.FetchTModelsQuery;
import org.apache.juddi.query.FindBindingByCategoryGroupQuery;
import org.apache.juddi.query.FindBindingByCategoryQuery;
import org.apache.juddi.query.FindBindingByTModelKeyQuery;
import org.apache.juddi.query.FindBusinessByCategoryGroupQuery;
import org.apache.juddi.query.FindBusinessByCategoryQuery;
import org.apache.juddi.query.FindBusinessByDiscoveryURLQuery;
import org.apache.juddi.query.FindBusinessByIdentifierQuery;
import org.apache.juddi.query.FindBusinessByNameQuery;
import org.apache.juddi.query.FindBusinessByTModelKeyQuery;
import org.apache.juddi.query.FindServiceByCategoryGroupQuery;
import org.apache.juddi.query.FindServiceByCategoryQuery;
import org.apache.juddi.query.FindServiceByNameQuery;
import org.apache.juddi.query.FindServiceByTModelKeyQuery;
import org.apache.juddi.query.FindTModelByCategoryGroupQuery;
import org.apache.juddi.query.FindTModelByCategoryQuery;
import org.apache.juddi.query.FindTModelByIdentifierQuery;
import org.apache.juddi.query.FindTModelByNameQuery;
import org.apache.juddi.query.util.DynamicQuery;
import org.apache.juddi.query.util.FindQualifiers;
import org.apache.juddi.v3.error.ErrorMessage;
import org.apache.juddi.v3.error.InvalidKeyPassedException;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.Direction;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.ListDescription;
import org.uddi.api_v3.RelatedBusinessInfo;
import org.uddi.api_v3.RelatedBusinessInfos;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModelBag;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.DispositionReportFaultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InquiryHelper {
    public static List<?> findBinding(FindBinding body, FindQualifiers findQualifiers, EntityManager em) throws DispositionReportFaultMessage {
        List<?> keysFound = null;
        if (body.getTModelBag() == null) {
            body.setTModelBag(new TModelBag());
        }
        InquiryHelper.doFindTModelEmbeddedSearch(em, body.getFindQualifiers(), body.getFindTModel(), body.getTModelBag());
        keysFound = FindBindingByTModelKeyQuery.select(em, findQualifiers, body.getTModelBag(), body.getServiceKey(), keysFound, new DynamicQuery.Parameter[0]);
        keysFound = FindBindingByCategoryQuery.select(em, findQualifiers, body.getCategoryBag(), body.getServiceKey(), keysFound);
        keysFound = FindBindingByCategoryGroupQuery.select(em, findQualifiers, body.getCategoryBag(), body.getServiceKey(), keysFound);
        return keysFound;
    }

    public static BindingDetail getBindingDetailFromKeys(FindBinding body, FindQualifiers findQualifiers, EntityManager em, List<?> keysFound) throws DispositionReportFaultMessage {
        return InquiryHelper.getBindingDetailFromKeys(body, findQualifiers, em, keysFound, null, null, null, null);
    }

    public static BindingDetail getBindingDetailFromKeys(FindBinding body, FindQualifiers findQualifiers, EntityManager em, List<?> keysFound, Date modifiedAfter, Date modifiedBefore, Holder<Integer> subscriptionStartIndex, Integer subscriptionMaxRows) throws DispositionReportFaultMessage {
        BindingDetail result = new BindingDetail();
        ListDescription listDesc = new ListDescription();
        result.setListDescription(listDesc);
        List<?> queryResults = FetchBindingTemplatesQuery.select(em, findQualifiers, keysFound, body.getMaxRows(), body.getListHead(), listDesc, new DynamicQuery.Parameter[0]);
        int currentIndex = 0;
        if (subscriptionStartIndex != null && subscriptionStartIndex.value != null) {
            currentIndex = (Integer)subscriptionStartIndex.value;
        }
        int returnedRowCount = 0;
        while (currentIndex < queryResults.size()) {
            Object item = queryResults.get(currentIndex);
            BindingTemplate modelBindingTemplate = (BindingTemplate)item;
            org.uddi.api_v3.BindingTemplate apiBindingTemplate = new org.uddi.api_v3.BindingTemplate();
            if (modifiedAfter != null && modifiedAfter.after(modelBindingTemplate.getModifiedIncludingChildren())) {
                ++currentIndex;
                continue;
            }
            if (modifiedBefore != null && modifiedBefore.before(modelBindingTemplate.getModifiedIncludingChildren())) {
                ++currentIndex;
                continue;
            }
            MappingModelToApi.mapBindingTemplate(modelBindingTemplate, apiBindingTemplate);
            result.getBindingTemplate().add(apiBindingTemplate);
            if (subscriptionMaxRows != null && ++returnedRowCount == subscriptionMaxRows) break;
            ++currentIndex;
        }
        if (currentIndex < queryResults.size() - 1) {
            if (subscriptionStartIndex != null) {
                subscriptionStartIndex.value = currentIndex + 1;
            }
        } else if (subscriptionStartIndex != null) {
            subscriptionStartIndex.value = null;
        }
        return result;
    }

    public static List<?> findBusiness(FindBusiness body, FindQualifiers findQualifiers, EntityManager em) throws DispositionReportFaultMessage {
        List<?> keysFound = null;
        if (body.getTModelBag() == null) {
            body.setTModelBag(new TModelBag());
        }
        InquiryHelper.doFindTModelEmbeddedSearch(em, body.getFindQualifiers(), body.getFindTModel(), body.getTModelBag());
        if (body.getFindRelatedBusinesses() != null) {
            FindRelatedBusinesses frb = body.getFindRelatedBusinesses();
            RelatedBusinessInfos relatedBusinessInfos = new RelatedBusinessInfos();
            if (body.getFindRelatedBusinesses().getBusinessKey() != null) {
                InquiryHelper.getRelatedBusinesses(em, Direction.FROM_KEY, frb.getBusinessKey(), frb.getKeyedReference(), relatedBusinessInfos);
                InquiryHelper.getRelatedBusinesses(em, Direction.TO_KEY, frb.getBusinessKey(), frb.getKeyedReference(), relatedBusinessInfos);
            } else if (body.getFindRelatedBusinesses().getFromKey() != null) {
                InquiryHelper.getRelatedBusinesses(em, Direction.FROM_KEY, frb.getFromKey(), frb.getKeyedReference(), relatedBusinessInfos);
            } else if (body.getFindRelatedBusinesses().getToKey() != null) {
                InquiryHelper.getRelatedBusinesses(em, Direction.TO_KEY, frb.getToKey(), frb.getKeyedReference(), relatedBusinessInfos);
            }
            ArrayList relatedBusinessKeys = new ArrayList(0);
            for (RelatedBusinessInfo rbi : relatedBusinessInfos.getRelatedBusinessInfo()) {
                relatedBusinessKeys.add(rbi.getBusinessKey());
            }
            keysFound = relatedBusinessKeys;
        }
        keysFound = FindBusinessByTModelKeyQuery.select(em, findQualifiers, body.getTModelBag(), keysFound, new DynamicQuery.Parameter[0]);
        keysFound = FindBusinessByIdentifierQuery.select(em, findQualifiers, body.getIdentifierBag(), keysFound);
        keysFound = FindBusinessByDiscoveryURLQuery.select(em, findQualifiers, body.getDiscoveryURLs(), keysFound, new DynamicQuery.Parameter[0]);
        keysFound = FindBusinessByCategoryQuery.select(em, findQualifiers, body.getCategoryBag(), keysFound);
        keysFound = FindBusinessByCategoryGroupQuery.select(em, findQualifiers, body.getCategoryBag(), keysFound);
        keysFound = FindBusinessByNameQuery.select(em, findQualifiers, body.getName(), keysFound);
        return keysFound;
    }

    public static BusinessList getBusinessListFromKeys(FindBusiness body, FindQualifiers findQualifiers, EntityManager em, List<?> keysFound) throws DispositionReportFaultMessage {
        return InquiryHelper.getBusinessListFromKeys(body, findQualifiers, em, keysFound, null, null, null, null);
    }

    public static BusinessList getBusinessListFromKeys(FindBusiness body, FindQualifiers findQualifiers, EntityManager em, List<?> keysFound, Date modifiedAfter, Date modifiedBefore, Holder<Integer> subscriptionStartIndex, Integer subscriptionMaxRows) throws DispositionReportFaultMessage {
        BusinessList result = new BusinessList();
        ListDescription listDesc = new ListDescription();
        result.setListDescription(listDesc);
        List<?> queryResults = FetchBusinessEntitiesQuery.select(em, findQualifiers, keysFound, body.getMaxRows(), body.getListHead(), listDesc, new DynamicQuery.Parameter[0]);
        if (queryResults != null && queryResults.size() > 0) {
            result.setBusinessInfos(new BusinessInfos());
        }
        int currentIndex = 0;
        if (subscriptionStartIndex != null && subscriptionStartIndex.value != null) {
            currentIndex = (Integer)subscriptionStartIndex.value;
        }
        int returnedRowCount = 0;
        while (currentIndex < queryResults.size()) {
            Object item = queryResults.get(currentIndex);
            BusinessEntity modelBusinessEntity = (BusinessEntity)item;
            BusinessInfo apiBusinessInfo = new BusinessInfo();
            if (modifiedAfter != null && modifiedAfter.after(modelBusinessEntity.getModifiedIncludingChildren())) {
                ++currentIndex;
                continue;
            }
            if (modifiedBefore != null && modifiedBefore.before(modelBusinessEntity.getModifiedIncludingChildren())) {
                ++currentIndex;
                continue;
            }
            MappingModelToApi.mapBusinessInfo(modelBusinessEntity, apiBusinessInfo);
            result.getBusinessInfos().getBusinessInfo().add(apiBusinessInfo);
            if (subscriptionMaxRows != null && ++returnedRowCount == subscriptionMaxRows) break;
            ++currentIndex;
        }
        if (currentIndex < queryResults.size() - 1) {
            if (subscriptionStartIndex != null) {
                subscriptionStartIndex.value = currentIndex + 1;
            }
        } else if (subscriptionStartIndex != null) {
            subscriptionStartIndex.value = null;
        }
        return result;
    }

    public static List<?> findService(FindService body, FindQualifiers findQualifiers, EntityManager em) throws DispositionReportFaultMessage {
        List<?> keysFound = null;
        if (body.getTModelBag() == null) {
            body.setTModelBag(new TModelBag());
        }
        InquiryHelper.doFindTModelEmbeddedSearch(em, body.getFindQualifiers(), body.getFindTModel(), body.getTModelBag());
        keysFound = FindServiceByTModelKeyQuery.select(em, findQualifiers, body.getTModelBag(), body.getBusinessKey(), keysFound, new DynamicQuery.Parameter[0]);
        keysFound = FindServiceByCategoryQuery.select(em, findQualifiers, body.getCategoryBag(), body.getBusinessKey(), keysFound);
        keysFound = FindServiceByCategoryGroupQuery.select(em, findQualifiers, body.getCategoryBag(), body.getBusinessKey(), keysFound);
        keysFound = FindServiceByNameQuery.select(em, findQualifiers, body.getName(), body.getBusinessKey(), keysFound);
        if (body.getTModelBag().getTModelKey().size() == 0) {
            body.setTModelBag(null);
        }
        return keysFound;
    }

    public static ServiceList getServiceListFromKeys(FindService body, FindQualifiers findQualifiers, EntityManager em, List<?> keysFound) throws DispositionReportFaultMessage {
        return InquiryHelper.getServiceListFromKeys(body, findQualifiers, em, keysFound, null, null, null, null);
    }

    public static ServiceList getServiceListFromKeys(FindService body, FindQualifiers findQualifiers, EntityManager em, List<?> keysFound, Date modifiedAfter, Date modifiedBefore, Holder<Integer> subscriptionStartIndex, Integer subscriptionMaxRows) throws DispositionReportFaultMessage {
        ServiceList result = new ServiceList();
        ListDescription listDesc = new ListDescription();
        result.setListDescription(listDesc);
        List<?> queryResults = FetchBusinessServicesQuery.select(em, findQualifiers, keysFound, body.getMaxRows(), body.getListHead(), listDesc, new DynamicQuery.Parameter[0]);
        if (queryResults != null && queryResults.size() > 0) {
            result.setServiceInfos(new ServiceInfos());
        }
        int currentIndex = 0;
        if (subscriptionStartIndex != null && subscriptionStartIndex.value != null) {
            currentIndex = (Integer)subscriptionStartIndex.value;
        }
        int returnedRowCount = 0;
        while (currentIndex < queryResults.size()) {
            Object item = queryResults.get(currentIndex);
            BusinessService modelBusinessService = (BusinessService)item;
            ServiceInfo apiServiceInfo = new ServiceInfo();
            if (modifiedAfter != null && modifiedAfter.after(modelBusinessService.getModifiedIncludingChildren())) {
                ++currentIndex;
                continue;
            }
            if (modifiedBefore != null && modifiedBefore.before(modelBusinessService.getModifiedIncludingChildren())) {
                ++currentIndex;
                continue;
            }
            MappingModelToApi.mapServiceInfo(modelBusinessService, apiServiceInfo);
            result.getServiceInfos().getServiceInfo().add(apiServiceInfo);
            if (subscriptionMaxRows != null && ++returnedRowCount == subscriptionMaxRows) break;
            ++currentIndex;
        }
        if (currentIndex < queryResults.size() - 1) {
            if (subscriptionStartIndex != null) {
                subscriptionStartIndex.value = currentIndex + 1;
            }
        } else if (subscriptionStartIndex != null) {
            subscriptionStartIndex.value = null;
        }
        return result;
    }

    public static List<?> findTModel(FindTModel body, FindQualifiers findQualifiers, EntityManager em) throws DispositionReportFaultMessage {
        List<?> keysFound = null;
        keysFound = FindTModelByIdentifierQuery.select(em, findQualifiers, body.getIdentifierBag(), keysFound);
        keysFound = FindTModelByCategoryQuery.select(em, findQualifiers, body.getCategoryBag(), keysFound);
        keysFound = FindTModelByCategoryGroupQuery.select(em, findQualifiers, body.getCategoryBag(), keysFound);
        keysFound = FindTModelByNameQuery.select(em, findQualifiers, body.getName(), keysFound, new DynamicQuery.Parameter[0]);
        return keysFound;
    }

    public static TModelList getTModelListFromKeys(FindTModel body, FindQualifiers findQualifiers, EntityManager em, List<?> keysFound) throws DispositionReportFaultMessage {
        return InquiryHelper.getTModelListFromKeys(body, findQualifiers, em, keysFound, null, null, null, null);
    }

    public static TModelList getTModelListFromKeys(FindTModel body, FindQualifiers findQualifiers, EntityManager em, List<?> keysFound, Date modifiedAfter, Date modifiedBefore, Holder<Integer> subscriptionStartIndex, Integer subscriptionMaxRows) throws DispositionReportFaultMessage {
        TModelList result = new TModelList();
        ListDescription listDesc = new ListDescription();
        result.setListDescription(listDesc);
        List<?> queryResults = FetchTModelsQuery.select(em, findQualifiers, keysFound, body.getMaxRows(), body.getListHead(), listDesc, new DynamicQuery.Parameter[0]);
        if (queryResults != null && queryResults.size() > 0) {
            result.setTModelInfos(new TModelInfos());
        }
        int currentIndex = 0;
        if (subscriptionStartIndex != null && subscriptionStartIndex.value != null) {
            currentIndex = (Integer)subscriptionStartIndex.value;
        }
        int returnedRowCount = 0;
        while (currentIndex < queryResults.size()) {
            Object item = queryResults.get(currentIndex);
            Tmodel modelTModel = (Tmodel)item;
            TModelInfo apiTModelInfo = new TModelInfo();
            if (modifiedAfter != null && modifiedAfter.after(modelTModel.getModifiedIncludingChildren())) {
                ++currentIndex;
                continue;
            }
            if (modifiedBefore != null && modifiedBefore.before(modelTModel.getModifiedIncludingChildren())) {
                ++currentIndex;
                continue;
            }
            MappingModelToApi.mapTModelInfo(modelTModel, apiTModelInfo);
            result.getTModelInfos().getTModelInfo().add(apiTModelInfo);
            if (subscriptionMaxRows != null && ++returnedRowCount == subscriptionMaxRows) break;
            ++currentIndex;
        }
        if (currentIndex < queryResults.size() - 1) {
            if (subscriptionStartIndex != null) {
                subscriptionStartIndex.value = currentIndex + 1;
            }
        } else if (subscriptionStartIndex != null) {
            subscriptionStartIndex.value = null;
        }
        return result;
    }

    public static void getRelatedBusinesses(EntityManager em, Direction direction, String focalKey, KeyedReference keyedRef, RelatedBusinessInfos relatedBusinessInfos) throws DispositionReportFaultMessage {
        InquiryHelper.getRelatedBusinesses(em, direction, focalKey, keyedRef, relatedBusinessInfos, null, null);
    }

    public static void getRelatedBusinesses(EntityManager em, Direction direction, String focalKey, KeyedReference keyedRef, RelatedBusinessInfos relatedBusinessInfos, Date modifiedAfter, Date modifiedBefore) throws DispositionReportFaultMessage {
        BusinessEntity focalBusiness;
        if (relatedBusinessInfos == null) {
            relatedBusinessInfos = new RelatedBusinessInfos();
        }
        if ((focalBusiness = (BusinessEntity)em.find(BusinessEntity.class, (Object)focalKey)) == null) {
            throw new InvalidKeyPassedException(new ErrorMessage("errors.invalidkey.BusinessNotFound", focalKey));
        }
        List<PublisherAssertion> pubAssertList = null;
        pubAssertList = direction == Direction.FROM_KEY ? focalBusiness.getPublisherAssertionsForFromKey() : focalBusiness.getPublisherAssertionsForToKey();
        if (pubAssertList != null) {
            for (PublisherAssertion modelPublisherAssertion : pubAssertList) {
                if (!"true".equalsIgnoreCase(modelPublisherAssertion.getFromCheck()) || !"true".equalsIgnoreCase(modelPublisherAssertion.getToCheck()) || keyedRef != null && (!keyedRef.getTModelKey().equals(modelPublisherAssertion.getTmodelKey()) || !keyedRef.getKeyName().equals(modelPublisherAssertion.getKeyName()) || !keyedRef.getKeyValue().equals(modelPublisherAssertion.getKeyValue()))) continue;
                BusinessEntity modelRelatedBusiness = null;
                modelRelatedBusiness = direction == Direction.FROM_KEY ? (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPublisherAssertion.getId().getToKey()) : (BusinessEntity)em.find(BusinessEntity.class, (Object)modelPublisherAssertion.getId().getFromKey());
                if (modifiedAfter != null && modifiedAfter.after(modelRelatedBusiness.getModifiedIncludingChildren()) || modifiedBefore != null && modifiedBefore.before(modelRelatedBusiness.getModifiedIncludingChildren())) continue;
                RelatedBusinessInfo apiRelatedBusinessInfo = new RelatedBusinessInfo();
                MappingModelToApi.mapRelatedBusinessInfo(modelPublisherAssertion, modelRelatedBusiness, direction, apiRelatedBusinessInfo);
                relatedBusinessInfos.getRelatedBusinessInfo().add(apiRelatedBusinessInfo);
            }
        }
    }

    public static RelatedBusinessesList getRelatedBusinessesList(FindRelatedBusinesses body, EntityManager em) throws DispositionReportFaultMessage {
        return InquiryHelper.getRelatedBusinessesList(body, em, null, null);
    }

    public static RelatedBusinessesList getRelatedBusinessesList(FindRelatedBusinesses body, EntityManager em, Date modifiedAfter, Date modifiedBefore) throws DispositionReportFaultMessage {
        RelatedBusinessesList result = new RelatedBusinessesList();
        ListDescription listDesc = new ListDescription();
        result.setListDescription(listDesc);
        RelatedBusinessInfos relatedBusinessInfos = new RelatedBusinessInfos();
        if (body.getBusinessKey() != null) {
            InquiryHelper.getRelatedBusinesses(em, Direction.FROM_KEY, body.getBusinessKey(), body.getKeyedReference(), relatedBusinessInfos, modifiedAfter, modifiedBefore);
            InquiryHelper.getRelatedBusinesses(em, Direction.TO_KEY, body.getBusinessKey(), body.getKeyedReference(), relatedBusinessInfos, modifiedAfter, modifiedBefore);
        } else if (body.getFromKey() != null) {
            InquiryHelper.getRelatedBusinesses(em, Direction.FROM_KEY, body.getFromKey(), body.getKeyedReference(), relatedBusinessInfos, modifiedAfter, modifiedBefore);
        } else if (body.getToKey() != null) {
            InquiryHelper.getRelatedBusinesses(em, Direction.TO_KEY, body.getToKey(), body.getKeyedReference(), relatedBusinessInfos, modifiedAfter, modifiedBefore);
        }
        if (relatedBusinessInfos.getRelatedBusinessInfo().size() > 0) {
            listDesc.setActualCount(relatedBusinessInfos.getRelatedBusinessInfo().size());
            listDesc.setIncludeCount(relatedBusinessInfos.getRelatedBusinessInfo().size());
            listDesc.setListHead(1);
            result.setRelatedBusinessInfos(relatedBusinessInfos);
        }
        return result;
    }

    private static void doFindTModelEmbeddedSearch(EntityManager em, org.uddi.api_v3.FindQualifiers fq, FindTModel findTmodel, TModelBag tmodelBag) throws DispositionReportFaultMessage {
        if (findTmodel != null && tmodelBag != null) {
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.mapApiFindQualifiers(fq);
            List<?> tmodelKeysFound = null;
            tmodelKeysFound = FindTModelByIdentifierQuery.select(em, findQualifiers, findTmodel.getIdentifierBag(), tmodelKeysFound);
            tmodelKeysFound = FindTModelByCategoryQuery.select(em, findQualifiers, findTmodel.getCategoryBag(), tmodelKeysFound);
            tmodelKeysFound = FindTModelByCategoryGroupQuery.select(em, findQualifiers, findTmodel.getCategoryBag(), tmodelKeysFound);
            tmodelKeysFound = FindTModelByNameQuery.select(em, findQualifiers, findTmodel.getName(), tmodelKeysFound, new DynamicQuery.Parameter[0]);
            if (tmodelKeysFound != null && tmodelKeysFound.size() > 0) {
                for (Object item : tmodelKeysFound) {
                    tmodelBag.getTModelKey().add((String)item);
                }
            }
        }
    }
}

