/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.api.impl;

import java.util.Date;
import javax.persistence.EntityManager;
import org.apache.juddi.model.AuthToken;
import org.apache.juddi.model.UddiEntityPublisher;
import org.apache.juddi.v3.auth.Authenticator;
import org.apache.juddi.v3.auth.AuthenticatorFactory;
import org.apache.juddi.v3.error.AuthTokenRequiredException;
import org.apache.juddi.v3.error.ErrorMessage;
import org.uddi.v3_service.DispositionReportFaultMessage;

public abstract class AuthenticatedService {
    public static final int AUTHTOKEN_ACTIVE = 1;
    public static final int AUTHTOKEN_RETIRED = 0;

    public UddiEntityPublisher getEntityPublisher(EntityManager em, String authInfo) throws DispositionReportFaultMessage {
        if (authInfo == null || authInfo.length() == 0) {
            throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthRequired"));
        }
        AuthToken modelAuthToken = (AuthToken)em.find(AuthToken.class, (Object)authInfo);
        if (modelAuthToken == null) {
            throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
        }
        if (modelAuthToken.getTokenState() == 0) {
            throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
        }
        Authenticator authenticator = AuthenticatorFactory.getAuthenticator();
        UddiEntityPublisher entityPublisher = authenticator.identify(authInfo, modelAuthToken.getAuthorizedName());
        if (entityPublisher == null) {
            throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
        }
        if (entityPublisher.getAuthorizedName() == null) {
            throw new AuthTokenRequiredException(new ErrorMessage("errors.auth.AuthInvalid"));
        }
        modelAuthToken.setLastUsed(new Date());
        modelAuthToken.setNumberOfUses(modelAuthToken.getNumberOfUses() + 1);
        return entityPublisher;
    }
}

