/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.gui.DirChooser;
import org.apache.ftpserver.gui.GuiUtils;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.ConcurrentLoginPermission;
import org.apache.ftpserver.usermanager.ConcurrentLoginRequest;
import org.apache.ftpserver.usermanager.TransferRatePermission;
import org.apache.ftpserver.usermanager.TransferRateRequest;
import org.apache.ftpserver.usermanager.WritePermission;
import org.apache.ftpserver.usermanager.WriteRequest;

public class UserManagerPanel
extends PluginPanel
implements ActionListener {
    private static final long serialVersionUID = 2496923918460548623L;
    private static final Random PASS_GEN = new Random(System.currentTimeMillis());
    private static final Object[] BYTE_RATES = new Object[]{"No limit", new Integer(1200), new Integer(2400), new Integer(4800), new Integer(9600), new Integer(14400), new Integer(28800), new Integer(57600), new Integer(115200)};
    private static final Object[] IDLE_SECONDS = new Object[]{"No limit", new Integer(60), new Integer(300), new Integer(900), new Integer(1800), new Integer(3600)};
    private static final Object[] MAX_LOGIN_NUMBER = new Object[]{"No limit", new Integer(5), new Integer(10), new Integer(20), new Integer(40)};
    private static final Object[] MAX_LOGIN_PER_IP = new Object[]{"No limit", new Integer(1), new Integer(2), new Integer(4), new Integer(8)};
    private FtpServerContext serverContext;
    private JComboBox userLst;
    private JTextField nameTxt;
    private JPasswordField passwordTxt;
    private JPasswordField retypePasswordTxt;
    private JCheckBox passwordChkBox;
    private JTextField directoryTxt;
    private JCheckBox enabledChkBox;
    private JCheckBox writeChkBox;
    private JComboBox loginNumberLst;
    private JComboBox loginPerIPLst;
    private JComboBox idleLst;
    private JComboBox uploadLst;
    private JComboBox downloadLst;

    public UserManagerPanel(PluginPanelContainer container) {
        super(container);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(4, 0, 0, 5);
        this.add((Component)topPanel, "Center");
        int yindex = -1;
        this.userLst = new JComboBox<String>(new String[]{"         "});
        this.userLst.addActionListener(this);
        this.userLst.setMinimumSize(new Dimension(160, 22));
        this.userLst.setPreferredSize(new Dimension(160, 22));
        gc.gridx = 0;
        ++yindex;
        gc.gridy = yindex++;
        gc.gridwidth = 3;
        gc.anchor = 10;
        topPanel.add((Component)this.userLst, gc);
        JLabel nameLab = new JLabel("Name :: ");
        nameLab.setHorizontalAlignment(4);
        nameLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)nameLab, gc);
        this.nameTxt = new JTextField();
        this.nameTxt.setColumns(12);
        this.nameTxt.setPreferredSize(new Dimension(120, 22));
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.nameTxt, gc);
        JLabel passwordLab = new JLabel("Password :: ");
        passwordLab.setHorizontalAlignment(4);
        passwordLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)passwordLab, gc);
        this.passwordTxt = new JPasswordField();
        this.passwordTxt.setColumns(12);
        this.passwordTxt.setPreferredSize(new Dimension(120, 22));
        gc.gridx = 1;
        gc.gridy = yindex;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.passwordTxt, gc);
        JButton generatePassBtn = new JButton("Generate");
        generatePassBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserManagerPanel.this.generatePassword();
            }
        });
        generatePassBtn.setPreferredSize(new Dimension(90, 22));
        gc.gridx = 2;
        gc.gridy = yindex++;
        gc.gridwidth = 1;
        gc.anchor = 17;
        topPanel.add((Component)generatePassBtn, gc);
        JLabel retypePasswordLab = new JLabel("Retype Password :: ");
        retypePasswordLab.setHorizontalAlignment(4);
        retypePasswordLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)retypePasswordLab, gc);
        this.retypePasswordTxt = new JPasswordField();
        this.retypePasswordTxt.setColumns(12);
        this.retypePasswordTxt.setPreferredSize(new Dimension(120, 22));
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.retypePasswordTxt, gc);
        JLabel setPasswordLab = new JLabel("Set Password :: ");
        setPasswordLab.setHorizontalAlignment(4);
        setPasswordLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)setPasswordLab, gc);
        this.passwordChkBox = new JCheckBox();
        this.passwordChkBox.setHorizontalTextPosition(2);
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.passwordChkBox, gc);
        JLabel directoryLab = new JLabel("Root Directory :: ");
        directoryLab.setHorizontalAlignment(4);
        directoryLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)directoryLab, gc);
        this.directoryTxt = new JTextField("./res/home");
        this.directoryTxt.setColumns(12);
        this.directoryTxt.setPreferredSize(new Dimension(120, 22));
        gc.gridx = 1;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 17;
        topPanel.add((Component)this.directoryTxt, gc);
        JButton directoryBtn = new JButton("Browse");
        directoryBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String dir = DirChooser.showDialog(UserManagerPanel.this, "Select User Home", null);
                if (dir != null) {
                    UserManagerPanel.this.directoryTxt.setText(dir);
                }
            }
        });
        directoryBtn.setPreferredSize(new Dimension(90, 22));
        gc.gridx = 2;
        gc.gridy = yindex++;
        gc.gridwidth = 1;
        gc.anchor = 17;
        topPanel.add((Component)directoryBtn, gc);
        JLabel enabledLab = new JLabel("Enabled :: ");
        enabledLab.setHorizontalAlignment(4);
        enabledLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)enabledLab, gc);
        this.enabledChkBox = new JCheckBox();
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.enabledChkBox, gc);
        JLabel writePermLab = new JLabel("Write Permission :: ");
        writePermLab.setHorizontalAlignment(4);
        writePermLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)writePermLab, gc);
        this.writeChkBox = new JCheckBox();
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.writeChkBox, gc);
        JLabel loginNumLab = new JLabel("Max. Login Number :: ");
        loginNumLab.setHorizontalAlignment(4);
        loginNumLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)loginNumLab, gc);
        this.loginNumberLst = new JComboBox<Object>(MAX_LOGIN_NUMBER);
        this.loginNumberLst.setPreferredSize(new Dimension(130, 22));
        this.loginNumberLst.setEditable(true);
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.loginNumberLst, gc);
        JLabel loginPerIPLab = new JLabel("Max. Login from Same IP :: ");
        loginPerIPLab.setHorizontalAlignment(4);
        loginPerIPLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)loginPerIPLab, gc);
        this.loginPerIPLst = new JComboBox<Object>(MAX_LOGIN_PER_IP);
        this.loginPerIPLst.setPreferredSize(new Dimension(130, 22));
        this.loginPerIPLst.setEditable(true);
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.loginPerIPLst, gc);
        JLabel idleLab = new JLabel("Max. Idle Time (seconds) :: ");
        idleLab.setHorizontalAlignment(4);
        idleLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)idleLab, gc);
        this.idleLst = new JComboBox<Object>(IDLE_SECONDS);
        this.idleLst.setPreferredSize(new Dimension(130, 22));
        this.idleLst.setEditable(true);
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.idleLst, gc);
        JLabel uploadLab = new JLabel("Max. Upload (bytes/sec) :: ");
        uploadLab.setHorizontalAlignment(4);
        uploadLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)uploadLab, gc);
        this.uploadLst = new JComboBox<Object>(BYTE_RATES);
        this.uploadLst.setPreferredSize(new Dimension(130, 22));
        this.uploadLst.setEditable(true);
        gc.gridx = 1;
        gc.gridy = yindex++;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.uploadLst, gc);
        JLabel jDownloadLab = new JLabel("Max. Download (bytes/sec) :: ");
        jDownloadLab.setHorizontalAlignment(4);
        jDownloadLab.setForeground(Color.black);
        gc.gridx = 0;
        gc.gridy = yindex;
        gc.gridwidth = 1;
        gc.anchor = 13;
        topPanel.add((Component)jDownloadLab, gc);
        this.downloadLst = new JComboBox<Object>(BYTE_RATES);
        this.downloadLst.setPreferredSize(new Dimension(130, 22));
        this.downloadLst.setEditable(true);
        gc.gridx = 1;
        gc.gridy = yindex;
        gc.gridwidth = 2;
        gc.anchor = 17;
        topPanel.add((Component)this.downloadLst, gc);
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.add((Component)btnPanel, "South");
        JButton saveBtn = new JButton("Save");
        saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserManagerPanel.this.save();
            }
        });
        btnPanel.add(saveBtn);
        JButton addBtn = new JButton("Add");
        addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserManagerPanel.this.add();
            }
        });
        btnPanel.add(addBtn);
        JButton deleteBtn = new JButton("Delete");
        deleteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserManagerPanel.this.delete();
            }
        });
        btnPanel.add(deleteBtn);
        JButton reloadBtn = new JButton("Reload");
        reloadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserManagerPanel.this.refresh(UserManagerPanel.this.serverContext);
            }
        });
        btnPanel.add(reloadBtn);
    }

    private void generatePassword() {
        StringBuffer sb = new StringBuffer(8);
        block5: for (int i = 0; i < 8; ++i) {
            int charType = PASS_GEN.nextInt(3);
            switch (charType) {
                case 0: {
                    sb.append((char)(48 + PASS_GEN.nextInt(10)));
                    continue block5;
                }
                case 1: {
                    sb.append((char)(65 + PASS_GEN.nextInt(26)));
                    continue block5;
                }
                case 2: {
                    sb.append((char)(97 + PASS_GEN.nextInt(26)));
                }
            }
        }
        String password = sb.toString();
        int option = JOptionPane.showConfirmDialog(this, "Generated password: " + password, "Password Generation", 2, 1);
        if (option == 0) {
            this.passwordTxt.setText(password);
            this.retypePasswordTxt.setText(password);
            this.passwordChkBox.setSelected(true);
        }
    }

    public void refresh(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        this.userLst.removeAllItems();
        if (this.serverContext == null) {
            return;
        }
        UserManager userManager = this.serverContext.getUserManager();
        try {
            String[] userNames = userManager.getAllUserNames();
            for (int i = 0; i < userNames.length; ++i) {
                this.userLst.addItem(userNames[i]);
            }
            if (userNames.length > 0) {
                this.userLst.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtils.showErrorMessage(this, "Cannot load user list.");
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object selVal = this.userLst.getSelectedItem();
        try {
            if (selVal != null) {
                String userName = selVal.toString();
                User user = this.serverContext.getUserManager().getUserByName(userName);
                if (user == null) {
                    GuiUtils.showErrorMessage(this, userName + " : does not exist.");
                    this.refresh(this.serverContext);
                } else {
                    this.nameTxt.setText(user.getName());
                    this.passwordTxt.setText("");
                    this.retypePasswordTxt.setText("");
                    this.passwordChkBox.setSelected(false);
                    this.directoryTxt.setText(user.getHomeDirectory());
                    this.enabledChkBox.setSelected(user.getEnabled());
                    this.writeChkBox.setSelected(user.authorize((AuthorizationRequest)new WriteRequest()) != null);
                    TransferRateRequest transferRateRequest = new TransferRateRequest();
                    transferRateRequest = (TransferRateRequest)user.authorize((AuthorizationRequest)transferRateRequest);
                    if (transferRateRequest != null) {
                        this.setByteRateCombo(this.uploadLst, transferRateRequest.getMaxUploadRate());
                        this.setByteRateCombo(this.downloadLst, transferRateRequest.getMaxDownloadRate());
                    } else {
                        this.setByteRateCombo(this.uploadLst, 0);
                        this.setByteRateCombo(this.downloadLst, 0);
                    }
                    ConcurrentLoginRequest concurrentLoginRequest = new ConcurrentLoginRequest(0, 0);
                    concurrentLoginRequest = (ConcurrentLoginRequest)user.authorize((AuthorizationRequest)concurrentLoginRequest);
                    if (concurrentLoginRequest != null) {
                        this.setLoginNumberCombo(this.loginNumberLst, concurrentLoginRequest.getMaxConcurrentLogins());
                        this.setLoginPerIPCombo(this.loginPerIPLst, concurrentLoginRequest.getMaxConcurrentLoginsPerIP());
                    } else {
                        this.setLoginNumberCombo(this.loginNumberLst, 0);
                        this.setLoginPerIPCombo(this.loginPerIPLst, 0);
                    }
                    this.setIdleTimeCombo(this.idleLst, user.getMaxIdleTime());
                }
            }
        }
        catch (FtpException ex) {
            GuiUtils.showErrorMessage(this, "Cannot fetch user information : " + selVal);
        }
    }

    private void save() {
        String userName = this.nameTxt.getText().trim();
        if (userName.equals("")) {
            GuiUtils.showErrorMessage(this, "Please enter an user name");
            return;
        }
        try {
            BaseUser user = new BaseUser();
            user.setName(userName);
            if (this.setPassword(user)) {
                user.setHomeDirectory(this.directoryTxt.getText());
                user.setEnabled(this.enabledChkBox.isSelected());
                ArrayList<Object> authorities = new ArrayList<Object>();
                if (this.writeChkBox.isSelected()) {
                    authorities.add(new WritePermission());
                }
                authorities.add(new TransferRatePermission(this.getBytesTransferRate(this.downloadLst), this.getBytesTransferRate(this.uploadLst)));
                authorities.add(new ConcurrentLoginPermission(this.getMaxLoginNumber(this.loginNumberLst), this.getMaxLoginPerIP(this.loginPerIPLst)));
                user.setAuthorities(authorities.toArray(new Authority[0]));
                user.setMaxIdleTime(this.getMaxIdleTime(this.idleLst));
                this.serverContext.getUserManager().save((User)user);
                this.refresh(this.serverContext);
                GuiUtils.showInformationMessage(this, "Saved user - " + user.getName());
            }
        }
        catch (Exception ex) {
            GuiUtils.showErrorMessage(this, ex.getMessage());
        }
    }

    private boolean setPassword(BaseUser usr) throws FtpException {
        String userName = usr.getName();
        boolean bNewUser = !this.serverContext.getUserManager().doesExist(userName);
        boolean bPassSet = this.passwordChkBox.isSelected();
        String password = new String(this.passwordTxt.getPassword());
        String repassword = new String(this.retypePasswordTxt.getPassword());
        boolean bAnonymous = userName.equals("anonymous");
        if (bNewUser && !bPassSet && !bAnonymous) {
            GuiUtils.showErrorMessage(this, "New user - password required");
            return false;
        }
        if (bPassSet && !password.equals(repassword) && !bAnonymous) {
            GuiUtils.showErrorMessage(this, "Password entries are not equal");
            return false;
        }
        if (bPassSet && !bAnonymous) {
            usr.setPassword(password);
        } else {
            usr.setPassword(null);
        }
        return true;
    }

    private int getMaxLoginNumber(JComboBox combo) {
        int maxLoginNumber = 0;
        Object selObj = combo.getSelectedItem();
        if (!selObj.equals(MAX_LOGIN_NUMBER[0])) {
            try {
                maxLoginNumber = Integer.parseInt(selObj.toString());
            }
            catch (NumberFormatException ex) {
                GuiUtils.showErrorMessage(this, ex.getMessage());
            }
        }
        return maxLoginNumber;
    }

    private int getMaxLoginPerIP(JComboBox combo) {
        int maxLoginPerIP = 0;
        Object selObj = combo.getSelectedItem();
        if (!selObj.equals(MAX_LOGIN_PER_IP[0])) {
            try {
                maxLoginPerIP = Integer.parseInt(selObj.toString());
            }
            catch (NumberFormatException ex) {
                GuiUtils.showErrorMessage(this, ex.getMessage());
            }
        }
        return maxLoginPerIP;
    }

    private int getBytesTransferRate(JComboBox combo) {
        int rate = 0;
        Object selObj = combo.getSelectedItem();
        if (!selObj.equals(BYTE_RATES[0])) {
            try {
                rate = Integer.parseInt(selObj.toString());
            }
            catch (NumberFormatException ex) {
                GuiUtils.showErrorMessage(this, ex.getMessage());
            }
        }
        return rate;
    }

    private int getMaxIdleTime(JComboBox combo) {
        int sec = 0;
        Object selObj = combo.getSelectedItem();
        if (!selObj.equals(IDLE_SECONDS[0])) {
            try {
                sec = Integer.parseInt(selObj.toString());
            }
            catch (NumberFormatException ex) {
                GuiUtils.showErrorMessage(this, ex.getMessage());
            }
        }
        return sec;
    }

    private void setByteRateCombo(JComboBox combo, int rate) {
        Object selItem = new Integer(rate);
        if (rate == 0) {
            selItem = BYTE_RATES[0];
        }
        combo.setSelectedItem(selItem);
    }

    private void setIdleTimeCombo(JComboBox combo, int idle) {
        Object selItem = new Integer(idle);
        if (idle == 0) {
            selItem = IDLE_SECONDS[0];
        }
        combo.setSelectedItem(selItem);
    }

    private void setLoginNumberCombo(JComboBox combo, int loginNumber) {
        Object selItem = new Integer(loginNumber);
        if (loginNumber == 0) {
            selItem = MAX_LOGIN_NUMBER[0];
        }
        combo.setSelectedItem(selItem);
    }

    private void setLoginPerIPCombo(JComboBox combo, int loginPerIP) {
        Object selItem = new Integer(loginPerIP);
        if (loginPerIP == 0) {
            selItem = MAX_LOGIN_NUMBER[0];
        }
        combo.setSelectedItem(selItem);
    }

    private void add() {
        String userName = JOptionPane.showInputDialog("User Name:");
        if (userName != null && !userName.trim().equals("")) {
            try {
                if (this.serverContext.getUserManager().doesExist(userName)) {
                    GuiUtils.showInformationMessage(this, "User Name already exists!");
                } else {
                    BaseUser user = new BaseUser();
                    user.setName(userName);
                    user.setPassword(userName);
                    Authority[] authorities = new Authority[]{new TransferRatePermission(0, 0)};
                    user.setAuthorities(authorities);
                    user.setEnabled(true);
                    user.setHomeDirectory("./res/home");
                    user.setMaxIdleTime(0);
                    this.serverContext.getUserManager().save((User)user);
                    this.refresh(this.serverContext);
                    this.userLst.setSelectedItem(userName);
                }
            }
            catch (FtpException ex) {
                ex.printStackTrace();
                GuiUtils.showErrorMessage(this, "Failed to save the User.");
            }
        }
    }

    private void delete() {
        Object selVal = this.userLst.getSelectedItem();
        if (selVal == null) {
            return;
        }
        String userName = selVal.toString();
        if (!GuiUtils.getConfirmation(this, "Do you really want to delete user " + userName + "?")) {
            return;
        }
        try {
            this.serverContext.getUserManager().delete(userName);
            this.refresh(this.serverContext);
            GuiUtils.showInformationMessage(this, "Deleted user - " + userName);
        }
        catch (Exception ex) {
            GuiUtils.showErrorMessage(this, "User delete error : " + userName);
        }
    }

    public boolean canBeDisplayed() {
        return this.serverContext != null;
    }

    public String toString() {
        return "Users";
    }
}

