/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.ftpserver.gui.GuiUtils;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.interfaces.FtpServerContext;

public class TreePluginPanelContainer
extends JSplitPane
implements PluginPanelContainer,
TreeModel,
TreeSelectionListener {
    private static final long serialVersionUID = -6807863406907626635L;
    private ArrayList pluginPanels = new ArrayList();
    private Vector treeListeners = new Vector();
    private FtpServerContext serverContext;
    private JPanel rightPane;
    private JTree tree;

    public void add(PluginPanel panel) {
        this.pluginPanels.add(panel);
    }

    public PluginPanel getPluginPanel(int index) {
        return (PluginPanel)this.pluginPanels.get(index);
    }

    public JComponent getComponent() {
        this.setDividerSize(2);
        this.setDividerLocation(110);
        this.tree = new JTree(this);
        this.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        this.tree.setCellRenderer(renderer);
        this.tree.addTreeSelectionListener(this);
        JScrollPane custPane = new JScrollPane(this.tree, 20, 30);
        this.setLeftComponent(custPane);
        this.rightPane = new JPanel(new BorderLayout());
        this.setRightComponent(this.rightPane);
        return this;
    }

    public int getSelectedIndex() {
        Object node = this.tree.getSelectionPath().getLastPathComponent();
        return this.pluginPanels.indexOf(node);
    }

    public void setSelectedIndex(int index) {
        this.tree.setSelectionRow(index);
    }

    public void valueChanged(TreeSelectionEvent e) {
        int[] rows = this.tree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        PluginPanel panel = (PluginPanel)this.pluginPanels.get(rows[rows.length - 1]);
        if (panel.canBeDisplayed()) {
            GuiUtils.showNewPanel(this.rightPane, panel);
        }
    }

    public Object getRoot() {
        return this.pluginPanels.get(0);
    }

    public int getChildCount(Object parent) {
        if (parent == this.pluginPanels.get(0)) {
            return this.pluginPanels.size() - 1;
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return node != this.pluginPanels.get(0);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.pluginPanels.indexOf(child) - 1;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeListeners.add(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeListeners.remove(l);
    }

    public Object getChild(Object parent, int index) {
        return this.pluginPanels.get(index + 1);
    }

    public void refresh(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        for (int i = 0; i < this.pluginPanels.size(); ++i) {
            PluginPanel ppanel = (PluginPanel)this.pluginPanels.get(i);
            ppanel.refresh(this.serverContext);
        }
    }

    public FtpServerContext getServerContext() {
        return this.serverContext;
    }
}

