/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.Dimension;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.apache.ftpserver.gui.ConnectionPanel;
import org.apache.ftpserver.gui.DirectoryPanel;
import org.apache.ftpserver.gui.FilePanel;
import org.apache.ftpserver.gui.GuiUtils;
import org.apache.ftpserver.gui.IPRestrictorPanel;
import org.apache.ftpserver.gui.LoggerPanel;
import org.apache.ftpserver.gui.MessagePanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.gui.RootPanel;
import org.apache.ftpserver.gui.SpyPanelContainer;
import org.apache.ftpserver.gui.StatisticsPanel;
import org.apache.ftpserver.gui.TreePluginPanelContainer;
import org.apache.ftpserver.gui.UserManagerPanel;

public class ServerFrame
extends JFrame {
    private static final long serialVersionUID = 8399655106217258507L;
    private PluginPanelContainer pluginContainer;

    public ServerFrame() {
        JTabbedPane tabPane = new JTabbedPane();
        this.getContentPane().add(tabPane);
        this.pluginContainer = new TreePluginPanelContainer();
        this.pluginContainer.add(new RootPanel(this.pluginContainer));
        this.pluginContainer.add(new UserManagerPanel(this.pluginContainer));
        this.pluginContainer.add(new IPRestrictorPanel(this.pluginContainer));
        this.pluginContainer.add(new MessagePanel(this.pluginContainer));
        this.pluginContainer.add(new ConnectionPanel(this.pluginContainer));
        this.pluginContainer.add(new SpyPanelContainer(this.pluginContainer));
        this.pluginContainer.add(new FilePanel(this.pluginContainer));
        this.pluginContainer.add(new DirectoryPanel(this.pluginContainer));
        this.pluginContainer.add(new LoggerPanel(this.pluginContainer));
        this.pluginContainer.add(new StatisticsPanel(this.pluginContainer));
        tabPane.addTab("FTP", this.pluginContainer.getComponent());
        this.pluginContainer.setSelectedIndex(0);
        this.setTitle("Apache FTP Server");
        ImageIcon icon = GuiUtils.createImageIcon("org/apache/ftpserver/gui/logo.gif");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setSize(new Dimension(620, 420));
        GuiUtils.setLocation(this);
        this.setVisible(true);
        this.toFront();
    }

    protected void processWindowEvent(WindowEvent e) {
        int id = e.getID();
        if (id == 201) {
            if (!GuiUtils.getConfirmation(this, "Do you really want to exit?")) {
                return;
            }
            super.processWindowEvent(e);
            RootPanel root = (RootPanel)this.pluginContainer.getPluginPanel(0);
            root.stopServer();
            this.dispose();
            System.exit(0);
        } else {
            super.processWindowEvent(e);
        }
    }

    public static void main(String[] args) {
        System.out.println("Opening UI window, please wait...");
        new ServerFrame();
    }
}

