/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.ftpserver.gui.GuiUtils;
import org.apache.ftpserver.gui.IPRestrictorTable;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.IpRestrictor;

public class IPRestrictorPanel
extends PluginPanel {
    private static final long serialVersionUID = -1871174667851171193L;
    private FtpServerContext serverContext;
    private IPRestrictorTable table;

    public IPRestrictorPanel(PluginPanelContainer container) {
        super(container);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.table = new IPRestrictorTable();
        this.add((Component)this.table, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)buttonPanel, "South");
        JButton saveBtn = new JButton("Save");
        saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPRestrictorPanel.this.saveData();
            }
        });
        buttonPanel.add(saveBtn);
        JButton reloadBtn = new JButton("Reload");
        reloadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPRestrictorPanel.this.reloadData();
            }
        });
        buttonPanel.add(reloadBtn);
    }

    private void saveData() {
        try {
            IpRestrictor restrictor = this.serverContext.getIpRestrictor();
            restrictor.setPermissions(this.table.getData());
        }
        catch (Exception ex) {
            GuiUtils.showErrorMessage(this, "Cannot save IP entries.");
        }
    }

    private void reloadData() {
        try {
            Object[][] perms = null;
            if (this.serverContext != null) {
                IpRestrictor restrictor = this.serverContext.getIpRestrictor();
                perms = restrictor.getPermissions();
            }
            this.table.setData(perms);
        }
        catch (Exception ex) {
            GuiUtils.showErrorMessage(this, "Cannot load IP entries.");
        }
    }

    public void refresh(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        this.reloadData();
    }

    public boolean canBeDisplayed() {
        return this.serverContext != null;
    }

    public String toString() {
        return "IP Restrictor";
    }
}

