/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class GuiUtils {
    public static final ImageIcon createImageIcon(String resource) {
        ImageIcon icon = null;
        URL imgUrl = GuiUtils.class.getClassLoader().getResource(resource);
        if (imgUrl != null) {
            try {
                icon = new ImageIcon(imgUrl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return icon;
    }

    public static final void showErrorMessage(Component parent, String str) {
        JOptionPane.showMessageDialog(parent, str, "Error!", 0);
    }

    public static final void showWarningMessage(Component parent, String str) {
        JOptionPane.showMessageDialog(parent, str, "Warning!", 2);
    }

    public static final void showInformationMessage(Component parent, String str) {
        JOptionPane.showMessageDialog(parent, str, "Information!", 1);
    }

    public static final boolean getConfirmation(Component parent, String str) {
        int res = JOptionPane.showConfirmDialog(parent, str, "Confirmation", 0, 3);
        return res == 0;
    }

    public static final void setLocation(Component comp) {
        Dimension cDim = comp.getSize();
        Dimension wDim = Toolkit.getDefaultToolkit().getScreenSize();
        comp.setLocation((wDim.width - cDim.width) / 2, (wDim.height - cDim.height) / 2);
    }

    public static final void setLocation(Component comp, Component parent) {
        Dimension cDim = comp.getSize();
        Rectangle pRect = parent.getBounds();
        int x = pRect.x + (pRect.width - cDim.width) / 2;
        int y = pRect.y + (pRect.height - cDim.height) / 2;
        comp.setLocation(x, y);
    }

    public static final void showNewPanel(Container parent, Component child) {
        parent.removeAll();
        parent.add(child);
        parent.validate();
        parent.repaint();
    }
}

