/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.ArrayList;
import java.util.List;
import org.drools.definition.process.Connection;
import org.drools.runtime.process.NodeInstance;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.instance.NodeInstanceContainer;
import org.drools.workflow.instance.impl.ConstraintEvaluator;
import org.drools.workflow.instance.impl.NodeInstanceImpl;

public class SplitInstance
extends NodeInstanceImpl {
    private static final long serialVersionUID = 400L;

    protected Split getSplit() {
        return (Split)this.getNode();
    }

    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A Split only accepts default incoming connections!");
        }
        Split split = this.getSplit();
        switch (split.getType()) {
            case 1: {
                this.triggerCompleted("DROOLS_DEFAULT", true);
                break;
            }
            case 2: {
                List<Connection> outgoing = split.getDefaultOutgoingConnections();
                int priority = Integer.MAX_VALUE;
                Connection selected = null;
                for (Connection connection : outgoing) {
                    ConstraintEvaluator constraint = (ConstraintEvaluator)split.getConstraint(connection);
                    if (constraint == null || constraint.getPriority() >= priority || !constraint.evaluate(this, connection, constraint)) continue;
                    selected = connection;
                    priority = constraint.getPriority();
                }
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                if (selected == null) {
                    throw new IllegalArgumentException("XOR split could not find at least one valid outgoing connection for split " + this.getSplit().getName());
                }
                this.triggerConnection(selected);
                break;
            }
            case 3: {
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                List<Connection> outgoing = split.getDefaultOutgoingConnections();
                boolean found = false;
                ArrayList<Connection> outgoingCopy = new ArrayList<Connection>(outgoing);
                while (!outgoingCopy.isEmpty()) {
                    int priority = Integer.MAX_VALUE;
                    Connection selectedConnection = null;
                    ConstraintEvaluator selectedConstraint = null;
                    for (Connection connection : outgoingCopy) {
                        ConstraintEvaluator constraint = (ConstraintEvaluator)split.getConstraint(connection);
                        if (constraint == null || constraint.getPriority() >= priority) continue;
                        priority = constraint.getPriority();
                        selectedConnection = connection;
                        selectedConstraint = constraint;
                    }
                    if (selectedConstraint.evaluate(this, selectedConnection, selectedConstraint)) {
                        this.triggerConnection(selectedConnection);
                        found = true;
                    }
                    outgoingCopy.remove(selectedConnection);
                }
                if (found) break;
                throw new IllegalArgumentException("OR split could not find at least one valid outgoing connection for split " + this.getSplit().getName());
            }
            default: {
                throw new IllegalArgumentException("Illegal split type " + split.getType());
            }
        }
    }
}

