/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.process.core.Context;
import org.drools.process.core.ContextContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextContainerImpl
implements Serializable,
ContextContainer {
    private static final long serialVersionUID = 400L;
    private Map<String, Context> defaultContexts = new HashMap<String, Context>();
    private Map<String, List<Context>> subContexts = new HashMap<String, List<Context>>();
    private long lastContextId;

    @Override
    public List<Context> getContexts(String contextType) {
        return this.subContexts.get(contextType);
    }

    @Override
    public void addContext(Context context) {
        List<Context> list = this.subContexts.get(context.getType());
        if (list == null) {
            list = new ArrayList<Context>();
            this.subContexts.put(context.getType(), list);
        }
        if (!list.contains(context)) {
            list.add(context);
            context.setId(++this.lastContextId);
        }
    }

    @Override
    public Context getContext(String contextType, long id) {
        List<Context> list = this.subContexts.get(contextType);
        if (list != null) {
            for (Context context : list) {
                if (context.getId() != id) continue;
                return context;
            }
        }
        return null;
    }

    @Override
    public void setDefaultContext(Context context) {
        this.defaultContexts.put(context.getType(), context);
    }

    @Override
    public Context getDefaultContext(String contextType) {
        return this.defaultContexts.get(contextType);
    }
}

