/*
 * Decompiled with CFR 0.152.
 */
package org.drools.facttemplates;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.ValueType;
import org.drools.facttemplates.Fact;
import org.drools.facttemplates.FactTemplate;
import org.drools.spi.ObjectType;

public class FactTemplateObjectType
implements ObjectType {
    private static final long serialVersionUID = 400L;
    protected FactTemplate factTemplate;
    private boolean isEvent;

    public FactTemplateObjectType() {
    }

    public FactTemplateObjectType(FactTemplate factTemplate) {
        this.factTemplate = factTemplate;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factTemplate = (FactTemplate)in.readObject();
        this.isEvent = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.factTemplate);
        out.writeBoolean(this.isEvent);
    }

    public FactTemplate getFactTemplate() {
        return this.factTemplate;
    }

    public boolean matches(Object object) {
        if (object instanceof Fact) {
            return this.factTemplate.equals(((Fact)object).getFactTemplate());
        }
        return false;
    }

    public boolean isAssignableFrom(Object object) {
        return this.factTemplate.equals(object);
    }

    public boolean isAssignableFrom(ObjectType objectType) {
        if (!(objectType instanceof FactTemplateObjectType)) {
            return false;
        }
        return this.factTemplate.equals(((FactTemplateObjectType)objectType).getFactTemplate());
    }

    public ValueType getValueType() {
        return ValueType.FACTTEMPLATE_TYPE;
    }

    public boolean isEvent() {
        return this.isEvent;
    }

    public void setEvent(boolean isEvent) {
        this.isEvent = isEvent;
    }

    public String toString() {
        return "[FactTemplateObjectType " + (this.isEvent ? "event=" : "template=") + this.factTemplate.getName() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof FactTemplateObjectType)) {
            return false;
        }
        FactTemplateObjectType other = (FactTemplateObjectType)object;
        return this.factTemplate.equals(other.factTemplate);
    }

    public int hashCode() {
        return this.factTemplate.hashCode();
    }
}

