/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseClassFieldReader;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;

public abstract class BaseDoubleClassFieldReader
extends BaseClassFieldReader {
    private static final long serialVersionUID = 400L;

    public BaseDoubleClassFieldReader(Class clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseDoubleClassFieldReader(int index, Class fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return new Double(this.getDoubleValue(workingMemory, object));
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from double");
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return (byte)this.getDoubleValue(workingMemory, object);
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        throw new RuntimeDroolsException("Conversion to char not supported from double");
    }

    public abstract double getDoubleValue(InternalWorkingMemory var1, Object var2);

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        return (float)this.getDoubleValue(workingMemory, object);
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return (int)this.getDoubleValue(workingMemory, object);
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return (long)this.getDoubleValue(workingMemory, object);
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return (short)this.getDoubleValue(workingMemory, object);
    }

    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        return false;
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getDoubleValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        long temp = Double.doubleToLongBits(this.getDoubleValue(workingMemory, object));
        return (int)(temp ^ temp >>> 32);
    }
}

