/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.mapper;

import it.javalinux.wise.core.mapper.WiseMapper;
import it.javalinux.wise.core.utils.SmooksCache;
import java.util.Map;
import org.milyn.Smooks;
import org.milyn.container.ExecutionContext;
import org.milyn.container.plugin.PayloadProcessor;
import org.milyn.container.plugin.ResultType;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.report.HtmlReportGenerator;
import org.milyn.payload.JavaResult;
import org.milyn.resource.URIResourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksMapper
implements WiseMapper {
    private String smooksResource;
    private String smooksReport = null;

    public SmooksMapper(String smooksResource) {
        this.smooksResource = smooksResource;
    }

    public SmooksMapper(String smooksResource, String smooksReport) {
        this.smooksResource = smooksResource;
        this.smooksReport = smooksReport;
    }

    @Override
    public Map<String, Object> applyMapping(Object originalObjects) throws Exception {
        Smooks smooks = SmooksCache.getInstance().get(this.smooksResource);
        if (smooks == null) {
            smooks = new Smooks();
            smooks.addConfigurations("smooks-resource", new URIResourceLocator().getResource(this.smooksResource));
            SmooksCache.getInstance().put(this.smooksResource, smooks);
        }
        ExecutionContext executionContext = smooks.createExecutionContext();
        JavaResult result = new JavaResult();
        if (this.getSmooksReport() != null) {
            executionContext.setEventListener((ExecutionEventListener)new HtmlReportGenerator(this.getSmooksReport()));
        }
        PayloadProcessor payloadProcessor = new PayloadProcessor(smooks, ResultType.JAVA);
        return (Map)payloadProcessor.process(originalObjects, executionContext);
    }

    public String getSmooksResource() {
        return this.smooksResource;
    }

    public void setSmooksResource(String smooksResource) {
        this.smooksResource = smooksResource;
    }

    public String getSmooksReport() {
        return this.smooksReport;
    }

    public void setSmooksReport(String smooksReport) {
        this.smooksReport = smooksReport;
    }
}

