/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.validation.units.tags;

import net.sourceforge.wife.validation.units.AbstractOptionalTag;

public class Tag13CValidationUnit
extends AbstractOptionalTag {
    public static final String CLSTIME = "CLSTIME";
    public static final String RNCTIME = "RNCTIME";
    public static final String SNDTIME = "SNDTIME";
    public static final String[] VALID_CODES = new String[]{"CLSTIME", "RNCTIME", "SNDTIME"};

    public Tag13CValidationUnit() {
        this.setAllowMultipleInstances(Boolean.TRUE);
    }

    public boolean evaluateValue(String value) {
        if (value.length() < 3) {
            return false;
        }
        int slash2 = value.indexOf(47, 1);
        if (slash2 < 0) {
            return false;
        }
        String code = value.substring(1, slash2);
        System.out.println("code: " + code);
        boolean codeOk = false;
        for (int i = 0; i < VALID_CODES.length; ++i) {
            if (!VALID_CODES[i].equals(code)) continue;
            codeOk = true;
        }
        if (!codeOk) {
            return false;
        }
        String time = value.substring(slash2 + 1);
        System.out.println("time: " + time);
        if (time.length() != 9) {
            return false;
        }
        if (!Character.isDigit(time.charAt(0))) {
            return false;
        }
        if (!Character.isDigit(time.charAt(1))) {
            return false;
        }
        if (!Character.isDigit(time.charAt(2))) {
            return false;
        }
        if (!Character.isDigit(time.charAt(3))) {
            return false;
        }
        if (time.charAt(4) != '-' && time.charAt(4) != '+') {
            return false;
        }
        if (!Character.isDigit(time.charAt(5))) {
            return false;
        }
        if (!Character.isDigit(time.charAt(6))) {
            return false;
        }
        if (!Character.isDigit(time.charAt(7))) {
            return false;
        }
        return Character.isDigit(time.charAt(8));
    }
}

