/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.wife.swift.model.SwiftTagListBlock;
import net.sourceforge.wife.swift.model.Tag;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SwiftBlock4
extends SwiftTagListBlock
implements Serializable {
    private static final long serialVersionUID = 1L;

    public SwiftBlock4() {
    }

    public SwiftBlock4(List tags) {
        Validate.notNull((Object)tags, (String)"parameter 'tags' cannot be null");
        Validate.allElementsOfType((Collection)tags, (Class)Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.addTags(tags);
    }

    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((blockNumber == 4 ? 1 : 0) != 0, (String)"blockNumber must be 4");
    }

    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((blockName.compareTo("4") == 0 ? 1 : 0) != 0, (String)"blockName must be string '4'");
    }

    public Integer getNumber() {
        return new Integer(4);
    }

    public String getName() {
        return "4";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean containsTag(int i) {
        if (this.tags == null || this.tags.isEmpty()) {
            return false;
        }
        Iterator it = this.tags.iterator();
        while (it.hasNext()) {
            Tag t = (Tag)it.next();
            if (!t.isNumber(i)) continue;
            return true;
        }
        return false;
    }

    public Tag getTagByNumber(int i) {
        if (this.tags != null && !this.tags.isEmpty()) {
            Iterator it = this.tags.iterator();
            while (it.hasNext()) {
                Tag t = (Tag)it.next();
                if (!t.isNumber(i)) continue;
                return t;
            }
        }
        return null;
    }
}

