/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

// This class was generated by the JAXRPC SI, do not edit.
// Contents subject to change without notice.
// JAX-RPC Standard Implementation (1.1.2_01, build R40)
// Generated source version: 1.1.2

package org.jboss.test.ws.jaxrpc.encoded.parametermode;


import java.util.HashMap;
import java.util.Map;

public class EnumInt {
    private int value;
    private static Map valueMap = new HashMap();
    public static final int _value1 = (int)-2147483648;
    public static final int _value2 = (int)2147483647;
    
    public static final EnumInt value1 = new EnumInt(_value1);
    public static final EnumInt value2 = new EnumInt(_value2);
    
    protected EnumInt(int value) {
        this.value = value;
        valueMap.put(this.toString(), this);
    }
    
    public int getValue() {
        return value;
    }
    
    public static EnumInt fromValue(int value)
        throws java.lang.IllegalStateException {
        if (value1.value == value) {
            return value1;
        } else if (value2.value == value) {
            return value2;
        }
        throw new IllegalArgumentException();
    }
    
    public static EnumInt fromString(String value)
        throws java.lang.IllegalStateException {
        EnumInt ret = (EnumInt)valueMap.get(value);
        if (ret != null) {
            return ret;
        }
        if (value.equals("-2147483648")) {
            return value1;
        } else if (value.equals("2147483647")) {
            return value2;
        }
        throw new IllegalArgumentException();
    }
    
    public String toString() {
        return new Integer(value).toString();
    }
    
    private Object readResolve()
        throws java.io.ObjectStreamException {
        return fromValue(getValue());
    }
    
    public boolean equals(Object obj) {
        if (!(obj instanceof EnumInt)) {
            return false;
        }
        return ((EnumInt)obj).value == value;
    }
    
    public int hashCode() {
        return new Integer(value).toString().hashCode();
    }
}
