/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

// This class was generated by the JAXRPC SI, do not edit.
// Contents subject to change without notice.
// JAX-RPC Standard Implementation (1.1.2_01, build R40)
// Generated source version: 1.1.2

package org.jboss.test.ws.jaxrpc.encoded.parametermode;


import java.util.HashMap;
import java.util.Map;

public class EnumFloat {
    private float value;
    private static Map valueMap = new HashMap();
    public static final float _value1 = (float)-1.00000000;
    public static final float _value2 = (float)3.00000000;
    
    public static final EnumFloat value1 = new EnumFloat(_value1);
    public static final EnumFloat value2 = new EnumFloat(_value2);
    
    protected EnumFloat(float value) {
        this.value = value;
        valueMap.put(this.toString(), this);
    }
    
    public float getValue() {
        return value;
    }
    
    public static EnumFloat fromValue(float value)
        throws java.lang.IllegalStateException {
        if (value1.value == value) {
            return value1;
        } else if (value2.value == value) {
            return value2;
        }
        throw new IllegalArgumentException();
    }
    
    public static EnumFloat fromString(String value)
        throws java.lang.IllegalStateException {
        EnumFloat ret = (EnumFloat)valueMap.get(value);
        if (ret != null) {
            return ret;
        }
        if (value.equals("-1.00000000")) {
            return value1;
        } else if (value.equals("3.00000000")) {
            return value2;
        }
        throw new IllegalArgumentException();
    }
    
    public String toString() {
        return new Float(value).toString();
    }
    
    private Object readResolve()
        throws java.io.ObjectStreamException {
        return fromValue(getValue());
    }
    
    public boolean equals(Object obj) {
        if (!(obj instanceof EnumFloat)) {
            return false;
        }
        return ((EnumFloat)obj).value == value;
    }
    
    public int hashCode() {
        return new Float(value).toString().hashCode();
    }
}
