/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.graph.log;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.hibernate.type.Type;

import org.jbpm.db.AbstractDbTestCase;
import org.jbpm.db.hibernate.LimitedStringType;
import org.jbpm.db.hibernate.LimitedTextType;
import org.jbpm.graph.def.Action;

public class ActionLogDbTest extends AbstractDbTestCase {

  public void testActionLog() {
    Action action = new Action();
    session.save(action);

    ActionLog actionLog = new ActionLog(action);
    actionLog = (ActionLog) saveAndReload(actionLog);
    assertNotNull(actionLog.getAction());

    session.delete(actionLog);
    session.delete(action);
  }

  public void testActionExceptionLog() {
    RuntimeException exception = createExceptionChain(null, 0);

    ActionLog actionLog = new ActionLog();
    actionLog.setException(exception);
    actionLog = (ActionLog) saveAndReload(actionLog);

    String exceptionString = actionLog.getException();
    assertNotNull("log exception is null", exceptionString);

    int expectedLength = 4000;
    if (!isLimitEnforced()) {
      StringWriter exceptionWriter = new StringWriter();
      exception.printStackTrace(new PrintWriter(exceptionWriter));
      expectedLength = exceptionWriter.getBuffer().length();
      assert expectedLength > 4000 : expectedLength;
    }

    int actualLength = exceptionString.length();
    assert actualLength == expectedLength : actualLength;

    session.delete(actionLog);
  }

  private boolean isLimitEnforced() {
    Type propertyType = session.getSessionFactory()
        .getClassMetadata(ActionLog.class)
        .getPropertyType("exception");
    return propertyType instanceof LimitedStringType || propertyType instanceof LimitedTextType;
  }

  private RuntimeException createExceptionChain(RuntimeException cause, int level) {
    return level == 100 ? cause : createExceptionChain(level % 10 == 0 ? new RuntimeException(
        "level " + level, cause) : cause, level + 1);
  }
}
