/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server;

import org.jboss.soa.esb.actions.TestMessageStore;
import org.jboss.soa.esb.actions.TestMessageStoreSink;
import org.jboss.system.ServiceMBeanSupport;

/**
 * MBean to monitor message flow in quickstart tests.
 *
 * @author <a href="kevin.conner@jboss.com">Kevin Conner</a>
 */
public class QuickstartMessageStoreImpl extends ServiceMBeanSupport implements QuickstartMessageStoreImplMBean
{
    private TestMessageStoreSink sink = new TestMessageStoreSink() ;
    
    @Override
    protected void startService() throws Exception
    {
        System.out.println("Starting service " + QuickstartMessageStoreImplMBean.objectName) ;
        super.startService();
        TestMessageStore.setMessageStoreSink(sink) ;
    }
    
    @Override
    protected void stopService() throws Exception
    {
        System.out.println("Stopping service " + QuickstartMessageStoreImplMBean.objectName) ;
        TestMessageStore.setMessageStoreSink(null) ;
        super.stopService();
    }
    
    public String[] waitForMessages(final int numberOfMessages, final long maxDelay)
    {
        return sink.waitForMessages(numberOfMessages, maxDelay) ;
    }

    public void clearMessages()
    {
        sink.clearMessages() ;
    }
}
