/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.server.jbpmReply;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;

import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.server.RedeliveryMBean;

/**
 * Action Handler for jBPM local test.
 */
public class ReplyAction extends AbstractActionLifecycle implements ActionPipelineProcessor
{
    /**
     * The reply type extension on the EPR.
     */
    public static final String REPLY_TYPE = "replyType" ;
    /**
     * Construct the action.
     */
    public ReplyAction(final ConfigTree config)
    {
    }
    
    /**
     * Handle reply.
     */
    public Message process(final Message message)
        throws ActionProcessingException
    {
        final Call call = message.getHeader().getCall() ;
        final EPR replyEPR = call.getReplyTo() ;
        final EPR toEPR = call.getTo() ;
        
        final String type = toEPR.getAddr().getExtensionValue(REPLY_TYPE) ;
        
        final String value ;
        final Message reply ;
        if (replyEPR == null)
        {
            value = "EsbNotifier:" + type ;
            reply = null ;
        }
        else
        {
            value = "EsbActionHandler:" + type ;
            reply = message ;
        }
        getRedeliveryMBean().logMessage(value) ;
        
        return reply ;
    }
    
    private RedeliveryMBean getRedeliveryMBean()
        throws ActionProcessingException
    {
        final MBeanServer server = MBeanServerLocator.locateJBoss();
        
        try
        {
            return (RedeliveryMBean) MBeanProxyExt.create(RedeliveryMBean.class, RedeliveryMBean.objectName, server);
        }
        catch (final MalformedObjectNameException mone)
        {
            throw new ActionProcessingException("Error retrieving MBean", mone) ;
        }
    }
    
    public void processException(final Message message, final Throwable th)
    {
    }
    
    public void processSuccess(final Message message)
    {
    }
}
