/*
 * RHQ Management Platform
 * Copyright (C) 2005-2008 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.jbosson.plugins.jbossesb;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/**
 * Discovers ESB Service entities from a ESB stats mbean
 *
 * @author Greg Hinkle
 * @param <T>
 */
public class ServiceDiscoveryComponent<T extends JMXComponent> extends SOADiscoveryComponent {
	
	private static Log log = LogFactory.getLog(ServiceDiscoveryComponent.class);
	
	protected ResourceContext<T> resourceContext;
		
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<MBeanResourceComponent> context) {
    	Set<DiscoveredResourceDetails> entities = new HashSet<DiscoveredResourceDetails>();

        EmsBean serviceBean = context.getParentResourceComponent().getEmsBean();
        Set<EmsAttribute> attributeSet = serviceBean.getAttributes();
        for (Iterator i = attributeSet.iterator(); i.hasNext();) {
        	EmsAttribute attr = (EmsAttribute) i.next();
        	System.out.println(attr.getName());
            //entities.add(detail);
        }

        /*
        String serviceName = serviceBean.getBeanName().getKeyProperty(SERVICE_NAME);

        // Do two passes - one to grab the entity names (ex. "data fileraction"
        // and then a second to build up the metrics for the entity
        Set<EmsAttribute> attributeSet = actionBean.getAttributes();
        for (Iterator i = attributeSet.iterator(); i.hasNext();) {
        	EmsAttribute attr = (EmsAttribute) i.next();
            entities.add(detail);
        }
        */
        return entities;
    }
}