/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2010
 */
package org.jboss.soa.esb.actions.soap.proxy;

import static org.junit.Assert.assertEquals;
import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.actions.soap.proxy.SOAPProxyWsdlLoader.DefaultSOAPProxyWsdlLoader;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.junit.Test;

/**
 * SOAPProxy unit test.
 * 
 * @author dward at jboss.org
 */
public class SOAPProxyUnitTest
{
	
	@Test
	public void test_fixRelative()
	{
		String[][] relativeHttpResources = new String[][] {
				new String[] {"http://foo.com/services/MyService.wsdl", "/schemas/MySchema.xsd", "http://foo.com/schemas/MySchema.xsd"},
				new String[] {"http://foo.com/services/MyService.wsdl", "../schemas/MySchema.xsd", "http://foo.com/schemas/MySchema.xsd"},
				new String[] {"http://foo.com/services/MyService.wsdl", "schemas/MySchema.xsd", "http://foo.com/services/schemas/MySchema.xsd"},
				new String[] {"http://foo.com/services/MyService.wsdl", "/MySchema.xsd", "http://foo.com/MySchema.xsd"},
				new String[] {"http://foo.com/services/old/MyService.wsdl", "../new/MySchema.xsd", "http://foo.com/services/new/MySchema.xsd"},
				new String[] {"http://foo.com/services/MyService.wsdl", "/test/MySchema.xsd", "http://foo.com/test/MySchema.xsd"},
				new String[] {"http://foo.com/services/old/MyService.wsdl", "../../test/MySchema.xsd", "http://foo.com/test/MySchema.xsd"},
				new String[] {"http://foo.com/services/MyService.wsdl", "./MySchema.xsd", "http://foo.com/services/MySchema.xsd"},
				new String[] {"http://foo.com/services/old/MyService.wsdl", "./../test/MySchema.xsd", "http://foo.com/services/test/MySchema.xsd"},
				new String[] {"http://foo.com/services/old/MyService.wsdl", ".././test/MySchema.xsd", "http://foo.com/services/test/MySchema.xsd"},
				new String[] {"http://foo.com/services/old/MyService.wsdl", ".././../test/MySchema.xsd", "http://foo.com/test/MySchema.xsd"},
				new String[] {"http://foo.com/services/old/MyService.wsdl", ".././../test/./MySchema.xsd", "http://foo.com/test/MySchema.xsd"},
		};
		SOAPProxyWsdlLoader loader = new DefaultSOAPProxyWsdlLoader(new ConfigTree("config"), null, true);
		for (String[] r : relativeHttpResources)
		{
			String actual = loader.fixRelative(r[0], r[1]);
			String expected = r[2];
			assertEquals(expected, actual);
		}
	}
	
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SOAPProxyUnitTest.class);
    }

}
