/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2009
 */
package org.jboss.soa.esb.actions.soap.proxy;

import java.io.IOException;
import java.net.URI;
import java.util.Properties;

import org.jboss.internal.soa.esb.publish.ContractInfo;
import org.jboss.internal.soa.esb.publish.ContractProvider;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.actions.soap.AuthBASICWsdlContractPublisher;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;

/**
 * SOAPProxy wsdl contract publisher.
 * 
 * @author dward at jboss.org
 */
public class SOAPProxyWsdlContractPublisher extends AuthBASICWsdlContractPublisher implements ContractProvider
{
	
	@Override
	public ContractInfo getContractInfo(Service service, String wsdlAddress) throws IOException
	{
		Properties properties = getActionProperties();
		ConfigTree config;
		if (service != null)
		{
			ConfigTree parent_config = new ConfigTree("parent_config");
			parent_config.setAttribute( ListenerTagNames.SERVICE_CATEGORY_NAME_TAG, service.getCategory() );
			parent_config.setAttribute( ListenerTagNames.SERVICE_NAME_TAG, service.getName() );
			config = new ConfigTree("config", parent_config);
		}
		else
		{
			config = new ConfigTree("config");
		}
		for ( Object key : properties.keySet() )
		{
			String name = (String)key;
			String value = properties.getProperty(name);
			config.setAttribute(name, value);
		}
		SOAPProxyWsdlLoader wsdl_loader;
		try
		{
			wsdl_loader = SOAPProxyWsdlLoader.newLoader(config);
		}
		catch (ConfigurationException ce)
		{
			throw (IOException)(new IOException(ce.getMessage()).initCause(ce));
		}
		try
		{
			return wsdl_loader.load(true);
		}
		finally
		{
			wsdl_loader.cleanup();
		}
	}
	
	public void setContractProperties(Properties contractProperties)
	{
		setActionProperties(contractProperties);
	}
	
	public ContractInfo provideContract(Service service) throws IOException
	{
		return provideContract(service, null);
	}
	
	public ContractInfo provideContract(Service service, String endpointAddressOverride) throws IOException
	{
		ContractInfo contract;
		if (endpointAddressOverride != null)
		{
			try
			{
				initializeTransformer();
			}
			catch (ConfigurationException ce)
			{
				throw new IOException( ce.getMessage() );
			}
			contract = getContractInfo( new EPR(URI.create(endpointAddressOverride)) );
		}
		else
		{
			// !!! *HAS* TO BE THE *SUPER* CLASS' IMPLEMENTATION !!!
			// --> AbstractWsdlContractPublisher.getContractInfo(String) <--
			contract = super.getContractInfo( service, getWsdlAddress() );
		}
		return contract; 
	}
	
}
