/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.actions.soap;

import java.util.Properties;

/**
 * AuthBASIC WSDL contract publisher.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class AuthBASICWsdlContractPublisher extends WsdlContractPublisher {

    public Properties getHttpClientProperties() {
        Properties httpClientProperties = (Properties) getActionProperties().clone();
        String configurators = httpClientProperties.getProperty("configurators");

        // Handle potential Http BASIC Auth....
        if(httpClientProperties.containsKey("username")) {
            httpClientProperties.setProperty("auth-username", httpClientProperties.getProperty("username"));
            if(httpClientProperties.containsKey("password")) {
                httpClientProperties.setProperty("auth-password", httpClientProperties.getProperty("password"));
            }

            // Only auto-configure the configurators if they're not already configured.
            // If they're configured in any way at all, we don't modify that.  If they're
            // not configured and a username/password is supplied, we assume BASIC Auth...
            if(configurators == null) {
                configurators = "AuthBASIC";
            }
        }

        if(configurators != null) {
            httpClientProperties.setProperty("configurators", configurators);
        }

        return httpClientProperties;
    }

}
