/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.converters;

import static org.junit.Assert.*;

import java.io.ByteArrayInputStream;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.Test;
import org.milyn.container.plugin.SourceResult;

/**
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>			
 *
 */
public class StreamToSourceResultUnitTest
{
	@Test
	public void process()
	{
		StreamToSourceResult action = new StreamToSourceResult();
		Message message = MessageFactory.getInstance().getMessage();
		ByteArrayInputStream inputStream = new ByteArrayInputStream( "testing".getBytes() );
		message.getBody().add( inputStream );
		message = action.process( message );
		
		Object object = message.getBody().get();
		assertTrue( object instanceof SourceResult );
		
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( StreamToSourceResultUnitTest.class );
	}

}
