/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.rules;

import java.util.List;
import java.util.Map;

/**
 * RuleInfoImpl contains rule execution configuration parameters that
 * are passed to the {@link RuleService}.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 * @since 4.6
 *
 */
public interface RuleInfo
{
    /**
	 * Source of the Rules.
	 *
	 * @return {@code String} The rule source.
     */
    String getRuleSource();

    /**
	 * The type of rule
	 *
	 * @return {@code String} The type of rule.
     */
    String getRuleType();

    /**
	 * The Domain Specific Language (dsl) for the the rules source.
	 *
	 * @return {@code String} The dsl source.
     */
    String getDslSource();

    /**
     * Determines if the rules should be reloaded upon execution.
     *
	 * @return {@code boolean} True if rules should be reloaded.
     */
    boolean getReload();

    /**
     * Facts that will be inserted into the working memory.
     *
     * @return {@code List<Object>}  List of Object that will be inserted as facts in the working memory.
     */
    List<Object> getDefaultFacts();

    /**
     * Global that will be inserted into the working memory (as globals).
     *
     * @return {@code <Map<String, Object>} Map of objects that will be inserted as globals in the working memory.
     */
    Map<String, Object> getGlobals();

    /**
     * Facts that will be inserted into working memory. These fact are indexed by a name which can be used
     * to support concepts as Entry Points.
     *
     * @return {@code <Map<String, List<Object>>} Map of lists that will be inserted as facts in the working memory,
     *                                          separated by the name. Used to support concepts like Entry Points.
     */
    Map<String, List<Object>> getFacts();

}