package org.jboss.soa.esb.services.jbpm.integration.timer;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;

import org.jboss.soa.esb.services.jbpm.integration.AbstractJmsJobService;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;

/**
 * Implementation of the jBPM scheduler service targeting quartz.
 * 
 * @author <a href='kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class JmsSchedulerService extends AbstractJmsJobService implements SchedulerService
{
    /**
     * Serial Version UID for this class.
     */
    private static final long serialVersionUID = -8830533950742335914L;

    /**
     * Create the JMS scheduler service.
     * @param jbpmContext The current jBPM context.
     * @param connectionFactory The associated JMS connection factory.
     * @param destination The JMS destination for jobs.
     * @param isCommitEnabled true if commit should be invoked, false otherwise.
     * @throws JMSException For errors in constructing the JMS session.
     */
    public JmsSchedulerService(final JbpmContext jbpmContext, final ConnectionFactory connectionFactory,
        final Destination destination, boolean isCommitEnabled)
        throws JMSException
    {
        super(jbpmContext, connectionFactory, destination, isCommitEnabled) ;
    }
    
    /**
     * Create a timer.
     * @param timer the timer to create.
     */
    public void createTimer(final Timer timer)
    {
        sendTimer(timer) ;
    }

    /**
     * Delete a specific timer.
     * @param timer The timer to delete.
     */
    public void deleteTimer(final Timer timer)
    {
        getJobSession().deleteJob(timer) ;
    }

    /**
     * Delete a specific timer given a name and associated jBPM token.
     * @param timerName The name of the timer to delete.
     * @param token The token associated with the timer.
     */
    public void deleteTimersByName(final String timerName, final Token token)
    {
        getJobSession().deleteTimersByName(timerName, token) ;
    }

    /**
     * Delete timers associated with a jBPM process instance.
     * @param processInstance The process instance associated with the timers.
     */
    public void deleteTimersByProcessInstance(final ProcessInstance processInstance)
    {
        getJobSession().deleteJobsForProcessInstance(processInstance) ;
    }
}
