package org.jboss.soa.esb.services.jbpm.cmd;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
/**
 * Convient Helper to set or set parameters on an EsbMessage.
 * @author kstam
 *
 */
public class MessageHelper 
{
	private static Logger _logger = Logger.getLogger(MessageHelper.class);
	
	public static String argumentException(String str)
	{
		return "Missing or invalid <"+str+"> object in Message body";
	}

	public static Message commandMessageTemplate() 			
	{
		Message template = MessageFactory.getInstance().getMessage();
		URI	 uri	= null;
		try  { uri = new URI(UUID.randomUUID().toString()); }
		catch (URISyntaxException e)
		{
			_logger.fatal("Problem with UUID.randomUUID() - This should not happen");
			return null;
		}
		template.getHeader().getCall().setMessageID(uri);

		return template;
	}

	public static void setLongValue(Message message, String key, Long value)
	{
		setObjectValue(message, key, value);
	}
	public static void setIntValue(Message message, String key, Integer value)
	{
		setObjectValue(message, key, value);
	}
	public static void setBooleanValue(Message message, String key, Boolean value)
	{
		setObjectValue(message, key, value);
	}
	public static void setObjectValue(Message message, String key, Object value)
	{
		message.getBody().add(key, value);
	}

	public static void setStringValue(Message msg,String key,Object obj)
	{
		setStringValue(msg, key, obj.toString());
	}

	public static void setStringValue(Message msg,String key,String str)
	{
		setObjectValue(msg, key, str);
	}

	public static void setStringListValue(Message msg,String key,String[] list)
	{
		boolean addComma = false;
		StringBuilder sb = new StringBuilder();
		for (String curr : list)
		{
			sb.append((addComma)?",":"").append(curr);
			addComma = true;
		}
		setObjectValue(msg,key, sb.toString());
	}

	public static void setVariablesMap(Message msg,String key,Map<String,Object> value)
	{
		msg.getBody().add(key, value);
	}

	public static Integer getIntValue(Message msg,String key)
	{
		Object obj = msg.getBody().get(key);
		if (obj instanceof Integer)		return (Integer)obj;
		if (obj instanceof String)		return Integer.parseInt((String)obj);
		_logger.error(argumentException(key));
        return null;
	}

	public static Long getLongValue(Message msg,String key)
	{
		Object obj = msg.getBody().get(key);
		if (null==obj)					return null;
		if (obj instanceof Long)		return (Long)obj;
		if (obj instanceof String)		return Long.parseLong((String)obj);
		if (obj instanceof Integer)		return new Long(obj.toString());
        _logger.error(argumentException(key));
        return null;
	}

	public static Boolean getBooleanValue(Message msg,String key)
	{
		return getBooleanValue(msg, key, null);
	}

	public static Boolean getBooleanValue(Message msg,String key, Boolean dflt) 
	{
		Object obj = msg.getBody().get(key);
		if (null==obj)					return dflt;
		if (obj instanceof Boolean)		return (Boolean)obj;
		if (obj instanceof String)		return Boolean.valueOf((String)obj);
        _logger.error(argumentException(key));
        return dflt;
	}

	public static String getStringValue(Message msg,String key)
	{
		return getStringValue(msg, key, null);
	}
    
	public static String getStringValue(Message msg,String key, String dflt)
	{
		Object obj = msg.getBody().get(key);
		if (null==obj)					return dflt;
		if (obj instanceof String)		return (String)obj;
        _logger.error(argumentException(key));
        return null;
	}

	@SuppressWarnings("unchecked")
	public static Map<String,Object>getVariablesMap(Message msg,String key)
	{
		Object obj = msg.getBody().get(key);
		if (null==obj)			return null;
		if (obj instanceof Map)	return (Map<String,Object>)obj;
        _logger.error(argumentException(key));
        return null;
	}

	public static Object getObjectValue(Message msg,String key)
	{
		return msg.getBody().get(key); 
	}

}
