/*
 * ServiceAlertMonitor2.java
 *
 * Created on November 21, 2006, 12:10 AM
 */
import javax.swing.UIManager;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Message;
import javax.jms.QueueReceiver;
import javax.jms.MessageListener;

/**
 *
 * @author  burr
 */
public class ServiceAlertMonitor extends javax.swing.JFrame implements MessageListener {
   InitialContext iniCtx = null;
   QueueConnectionFactory qcf = null;
   QueueConnection conn = null;
   QueueSession receiverSession = null;
   Queue receiverQueue = null;
   QueueReceiver queueReceiver = null;

   String imageName = "images/javawork.gif";
   
    /** Creates new form ServiceAlertMonitor */
    public ServiceAlertMonitor(String serviceName, String queueName, String imageName) {
        initComponents();
        this.jLabel1.setText(serviceName);
        try {
          if (iniCtx == null) iniCtx = new InitialContext();
          if (qcf == null) qcf = (QueueConnectionFactory) iniCtx.lookup("ConnectionFactory");
          if (conn == null) {
              conn = qcf.createQueueConnection();
              conn.start();
         }
          String responseQueueName = "queue/" + queueName;
          this.imageName = imageName;
          receiverQueue = (Queue) iniCtx.lookup(responseQueueName);
          receiverSession = conn.createQueueSession(false, QueueSession.AUTO_ACKNOWLEDGE);
    	  queueReceiver = receiverSession.createReceiver(receiverQueue); 
          queueReceiver.setMessageListener(this);          
        } catch (Exception e) {
            System.out.println(e);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        textAreaOrderQueue = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Service Alert Monitor");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Tahoma", 0, 18));
        jLabel1.setForeground(new java.awt.Color(0, 0, 204));
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("Service Alert Monitor");

        textAreaOrderQueue.setColumns(20);
        textAreaOrderQueue.setFont(new java.awt.Font("Arial", 0, 14));
        textAreaOrderQueue.setRows(5);
        textAreaOrderQueue.setTabSize(2);
        jScrollPane1.setViewportView(textAreaOrderQueue);

        jButton1.setText("Clear");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 265, Short.MAX_VALUE)
                    .add(jButton1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 265, Short.MAX_VALUE)
                    .add(jLabel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 265, Short.MAX_VALUE)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 265, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 39, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 98, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 84, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButton1)
                .addContainerGap())
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        try {
          if (queueReceiver != null) queueReceiver.close();
          if (receiverSession != null) receiverSession.close();
         
        } catch (JMSException e) {
            System.out.println(e);
        } 
    }//GEN-LAST:event_formWindowClosing

    boolean on = false;
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        textAreaOrderQueue.setText("");
        this.jLabel3.setIcon(null);
        //this.jLabel3.setVisible(false);
    }//GEN-LAST:event_jButton1ActionPerformed
    
        
    public void onMessage(Message msg) {
        try {
        String textMessage = ((TextMessage)msg).getText();
        textAreaOrderQueue.setText(textMessage);
        java.io.File x = new java.io.File(imageName);
        System.out.println(x.getAbsolutePath());
        javax.swing.ImageIcon icon = new javax.swing.ImageIcon(x.getAbsolutePath());  // animated gif        
        this.jLabel3.setIcon(icon);        
        this.jLabel3.setVisible(true);
        } catch (Exception e) {
            System.err.println(e);
            textAreaOrderQueue.setText("ERROR: " + e.getMessage());
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        System.out.println(args[0]);
        final String tempServiceName = args[0];
        System.out.println(args[1]);
        final String tempQueueName = args[1];
        System.out.println(args[2]);
        final String tempImageName = args[2];
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                ServiceAlertMonitor frame = new ServiceAlertMonitor(tempServiceName,tempQueueName,tempImageName);

                // center the window
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation(d.width/2 - frame.getWidth()/2, 
				d.height/2 - frame.getHeight()/2);                
                frame.setVisible(true);
            }
        });
    }

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea textAreaOrderQueue;
    // End of variables declaration//GEN-END:variables
    
}
