/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.util;

import junit.framework.TestCase;

import java.io.IOException;
import java.io.ByteArrayInputStream;
import java.util.jar.JarInputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.Enumeration;

import org.jboss.internal.soa.esb.util.StreamUtils;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class DeploymentArchiveUnitTest extends TestCase {

    public void test() throws IOException {
        DeploymentArchive archive = new DeploymentArchive("testarchive");

        archive.addEntry("//my/resource.txt", new ByteArrayInputStream("Hello ESB".getBytes()));
        archive.addEntry("my/folder");
        archive.addEntry(DeploymentArchive.class);

        JarInputStream jarStream = archive.toInputStream();
        JarEntry jarEntry;

        // my/resource.txt
        jarEntry = jarStream.getNextJarEntry();
        assertEquals("my/resource.txt", jarEntry.getName());
        assertEquals("Hello ESB", new String(StreamUtils.readStream(jarStream)));

        // my/folder
        jarEntry = jarStream.getNextJarEntry();
        assertEquals("my/folder/", jarEntry.getName());
        assertTrue(jarEntry.isDirectory());

        // DeploymentArchive.class
        jarEntry = jarStream.getNextJarEntry();
        assertEquals("org/jboss/soa/esb/util/DeploymentArchive.class", jarEntry.getName());
    }
}
