/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.testutils.jbr;

import junit.framework.TestCase;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;

import javax.management.MBeanServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class StaticRequestResponseHandler implements ServerInvocationHandler {

    private String response;
    private String expectedRequest;

    public StaticRequestResponseHandler(String response) {
        this.response = response;
    }

    public StaticRequestResponseHandler(InputStream response) {
        this.response = readStream(response);
    }

    public void setExpectedRequest(String expectedRequest) {
        this.expectedRequest = expectedRequest;
    }

    public void setExpectedRequest(InputStream expectedRequest) {
        this.expectedRequest = readStream(expectedRequest);
    }

    public Object invoke(InvocationRequest invocationRequest) throws Throwable {
        if(expectedRequest != null) {
            String payload = (String) invocationRequest.getParameter();
            TestCase.assertTrue(XMLHelper.compareXMLContent(expectedRequest, payload));
        }
        return response;
    }

    private String readStream(InputStream response) {
        try {
            return StreamUtils.readStreamString(response, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error reading stream.");
        } finally {
            try {
                response.close();
            } catch (IOException e) {
                throw new RuntimeException("Error closing stream.");
            }
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
    }

    public void setInvoker(ServerInvoker serverInvoker) {
    }

    public void addListener(InvokerCallbackHandler invokerCallbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler invokerCallbackHandler) {
    }
}
