/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.testutils;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * 
 * @author Daniel Bevenius				
 *
 */
public class StdOut2Log4jFilter extends FilterWriter
{
	/**
	 * log4j logger to log to
	 */
    protected Logger logger; 
    /**
     * Level to filter at
     */
    protected Level  level; 
    /**
     * string "buffer"
     */
    protected StringBuilder sb = new StringBuilder(); 
    /**
     * Carrage Return
     */
    private static final char CR = '\r';
    /**
     * Line Feed
     */
    private static final char LF = '\n';
    
    public StdOut2Log4jFilter( Writer writer )
    {
    	super( writer );
    }

    public StdOut2Log4jFilter( Writer writer, Logger logger, Level level )
    { 
		this( writer );
		
        this.logger = logger;
        this.level = level;
    } 

    public synchronized void write(int c) throws IOException 
    { 
        sb.append(c); 
    } 

    public synchronized void  write(char[] cbuf, int off, int len) throws IOException 
    { 
        sb.append( cbuf, off, len ); 
    } 

    public synchronized void  write(String str, int off, int len) throws IOException 
    { 
        sb.append( str.substring( off, off+len )); 
    } 

    public synchronized void flush() throws IOException 
    { 
        log(); 
    } 

    public synchronized void close() throws IOException 
    { 
        if ( sb.length() != 0) 
        	log(); 
    } 

    protected void finalize() throws Throwable 
    { 
        if ( sb.length() != 0) 
        { 
        	log(); 
    	} 
        super.finalize(); 
    } 

    protected void log() 
    { 
        stripExtraNewLine();
        logger.log(level, sb); 
        sb.delete(0,sb.length()); 
    } 
   
    protected final void stripExtraNewLine() 
    { 
        int length = sb.length(); 
        
        if ( length == 0 )
        	return;
        
        if ( length == 1 )
        {
            char last = sb.charAt(0); 
            if ( last == CR || last == LF )
                sb.deleteCharAt(0); 
        }
        else
        {
        	int lastPosition = length-1;
        	char secondLast = sb.charAt( lastPosition ); 
            if ( secondLast == CR ) 
                sb.deleteCharAt( lastPosition ); 
            else if ( secondLast == LF ) 
            { 
	        	int secondlastPosition = length-2;
                sb.deleteCharAt( lastPosition ); 
                if (sb.charAt( secondlastPosition ) == CR ) 
                    sb.deleteCharAt( secondlastPosition ); 
            } 
        }
    } 
}

