package org.jboss.soa.esb.testutils;

import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.Statement;

import org.apache.log4j.Logger;
import org.hsqldb.Server;
/**
 * Utility to start and stop a hsql Database.
 * 
 * @author <a href="mailto:kurt.stam@jboss.com">Kurt Stam</a>
 *
 */
public class HsqldbUtil 
{
	private static Logger log = Logger.getLogger( HsqldbUtil.class );
	
	final private static String THREAD_NAME = "hypersonic-unittest";
	
	/**
	 * Drop the hsql database if present.
	 * 
	 * @param databaseFile - i.e. build/hsqltestdb
	 * @throws Exception
	 */
	public static void dropHsqldb(final String databaseFile)
			throws Exception
	{
		final File file = new File(databaseFile) ;
		final File dir = file.getParentFile() ;
		if (dir.exists())
		{
			final String basename = file.getName() + "." ;
			final FileFilter fileFilter = new FileFilter() {
				public boolean accept(final File pathname) {
					return pathname.getName().startsWith(basename) ;
				}
			};
			final File[] listFiles = dir.listFiles(fileFilter) ;
			if (listFiles != null)
			{
				for(File dbFile: listFiles)
				{
					dbFile.delete() ;
				}
			}
		}
	}
	
	/**
	 * Starts the hsql database in it's own thread. 
	 * Don't forget to shut it down when you're done.
	 * 
	 * @param databaseFile - i.e. build/hsqltestdb
	 * @param databaseName - i.e. jbossesb
	 * @throws Exception
	 */
	public static Object startHsqldb(final String databaseFile,
			final String databaseName) throws Exception 
	{
		// Start DB in new thread, or else it will block us
		final Server server = new Server();
		Thread serverThread = new Thread(THREAD_NAME) {
			public void run() {
				try {
					// Start server
					Logger targetLogger = Logger.getLogger( "org.hsqldb" );
					server.setLogWriter( new PrintWriter( 
							new StdOut2Log4jFilter( server.getLogWriter(), log, targetLogger.getEffectiveLevel() )) );
					server.setDatabasePath( 0, databaseFile );
					server.setDatabaseName( 0, databaseName );
					server.setNoSystemExit( true );
					server.setSilent( true );
					server.start();
				} catch (Exception e) {
					log.error( e );
				}
				//log.error("Failed to start database", e);
			}
		};
		serverThread.run();
		serverThread.join();
		return server ;
	}
	/**
	 * 
	 * @param url
	 * @param username
	 * @param password
	 * @throws Exception
	 */
	public static void stopHsqldb(final Object serverObject) throws Exception {
		if ((serverObject != null) && (serverObject instanceof Server))
		{
			final Server server = (Server)serverObject;
			server.shutdown() ;
		}
	}
}
