/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.util;

import static org.junit.Assert.*;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.junit.Test;

import junit.framework.JUnit4TestAdapter;

/**
 * Unit test from CryptoUtil.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class CryptoUtilUnitTest
{
    @Test
    public void encryptDecryptRSA() throws NoSuchAlgorithmException, SecurityServiceException
    {
        final String payload = "Some text...";
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(1024);
        KeyPair keyPair = keyGen.generateKeyPair();

        byte[] encrypt = CryptoUtil.encrypt(payload.getBytes() , keyPair.getPublic(), keyPair.getPublic().getAlgorithm());
        byte[] decrypt = CryptoUtil.decrypt(encrypt, keyPair.getPrivate(), keyPair.getPrivate().getAlgorithm());
        assertEquals(payload, new String(decrypt));
    }

    @Test
    public void encryptDecryptDES() throws NoSuchAlgorithmException, SecurityServiceException
    {
        final String payload = "Some text...";
        KeyGenerator keyGen = KeyGenerator.getInstance("DES");
        keyGen.init(56);
        SecretKey secretKey = keyGen.generateKey();
        final String transformation = "DES/ECB/PKCS5Padding";

        byte[] encrypt = CryptoUtil.encrypt(payload.getBytes() , secretKey, transformation);

        byte[] decrypt = CryptoUtil.decrypt(encrypt, secretKey, transformation);
        assertEquals(payload, new String(decrypt));
    }

    @Test
    public void encryptDecryptTripleDES() throws NoSuchAlgorithmException, SecurityServiceException
    {
        dumpSecurityProviders();
        final String payload = "Some text...";
        KeyGenerator keyGen = KeyGenerator.getInstance("Blowfish");
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        final String transformation = "Blowfish/ECB/PKCS5Padding";

        byte[] encrypt = CryptoUtil.encrypt(payload.getBytes() , secretKey, transformation);

        byte[] decrypt = CryptoUtil.decrypt(encrypt, secretKey, transformation);
        assertEquals(payload, new String(decrypt));
    }

    @Test
    public void encryptDecryptTripleEAS() throws NoSuchAlgorithmException, SecurityServiceException
    {
        final String payload = "Some text...";
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        final String transformation = "AES/ECB/PKCS5Padding";

        byte[] encrypt = CryptoUtil.encrypt(payload.getBytes() , secretKey, transformation);

        byte[] decrypt = CryptoUtil.decrypt(encrypt, secretKey, transformation);
        assertEquals(payload, new String(decrypt));
    }


    @SuppressWarnings("unused")
    private void dumpSecurityProviders()
    {
        Provider[]  providers = Security.getProviders();
        for (Provider provider : providers)
        {
            System.out.println(provider.getServices());
        }
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(CryptoUtilUnitTest.class);
    }

}
