/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerTagNames;

/**
 * Util methods for help creating ConfigTree instances.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public final class SecurityConfigTestUtil
{
    private SecurityConfigTestUtil()
    {
    }

   public static ConfigTree createSecurityFragment(
            final String runAs,
            final String callerIdentity,
            final String moduleName)
    {
        final ConfigTree securityElement = new ConfigTree(ListenerTagNames.SECURITY_TAG);
        securityElement.setAttribute(ListenerTagNames.RUN_AS_TAG, runAs);
        securityElement.setAttribute(ListenerTagNames.USE_CALLERS_IDENTIDY_TAG, callerIdentity);
        securityElement.setAttribute(ListenerTagNames.MODULE_NAME_TAG, moduleName);
        return securityElement;
    }

    public static ConfigTree createSecurityFragment(
            final String runAs,
            final String callerIdentity,
            final String moduleName,
            final String alias)
    {
        final ConfigTree securityElement = createSecurityFragment(runAs, callerIdentity, moduleName);
        if ( alias != null )
        {
            ConfigTree property = new ConfigTree("property", securityElement);
            property.setAttribute("name", "alias");
            property.setAttribute("value", alias);
        }
        return securityElement;
    }

    public static ConfigTree createSecurityFragment(
            final String runAs,
            final String rolesAllowed,
            final String callerIdentity,
            final String moduleName,
            final String alias)
    {
        final ConfigTree securityElement = createSecurityFragment(runAs, callerIdentity, moduleName, alias);
        securityElement.setAttribute("rolesAllowed", rolesAllowed);
        return securityElement;
    }

}
