/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.notification;

import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

import junit.framework.TestCase;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

/**
 * NotifyTcp unit tests.
 */

public class NotifyTcpUnitTest extends TestCase
{
    public static final String DATA = "Hello World";

    public void testBadURI () throws Exception
    {
        ConfigTree rootEl = new ConfigTree("notif");
        ConfigTree tcpEl = new ConfigTree("destination", rootEl);

        try
        {
            new NotifyTcp(rootEl);
            fail("Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e)
        {
            // Expected
        }

        tcpEl.setAttribute("URI", "udp://foo:8080");

        try
        {
            new NotifyTcp(rootEl);
            fail("Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e)
        {
            // Expected
        }
    }

    public void testValidURI () throws Exception
    {
        ConfigTree rootEl = new ConfigTree("notif");
        ConfigTree tcpEl = new ConfigTree("destination", rootEl);

        tcpEl.setAttribute("URI", "tcp://localhost:9090");

        try
        {
            new NotifyTcp(rootEl);
        }
        catch (IllegalArgumentException e)
        {
            fail();
        }
    }

    public void testSend () throws Exception
    {
        try
        {
            ServerSocket sock = new ServerSocket(0);
            int port = sock.getLocalPort();
            Sender sender = new Sender(port);

            sender.start();

            Socket receiver = sock.accept();

            InputStream stream = receiver.getInputStream();

            while (stream.available() == 0)
            {
                Thread.yield();
            }

            byte[] data = new byte[stream.available()];

            stream.read(data);

            String receivedString = new String(data);

            if (!receivedString.startsWith(DATA))
            {
                System.err.println("Did not receive correct data: "
                        + receivedString);

                fail();
            }
        }
        catch (IllegalArgumentException e)
        {
            fail();
        }
    }

    class Sender extends Thread
    {
        public Sender(int s)
        {
            _port = s;
        }

        public void run ()
        {
            try
            {
                ConfigTree rootEl = new ConfigTree("notif");
                ConfigTree tcpEl = new ConfigTree("destination", rootEl);

                tcpEl.setAttribute("URI", "tcp://localhost:" + _port);

                Message msg = MessageFactory.getInstance().getMessage();

                msg.getBody().add(DATA);

                NotifyTcp test = new NotifyTcp(rootEl);

                test.sendNotification(msg);
            }
            catch (Throwable ex)
            {
                ex.printStackTrace();
            }
        }

        private int _port;
    }
}