/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.message;

import static org.junit.Assert.*;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.Before;
import org.junit.Test;

/**
 * Unit test for ServiceMessageCounter
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>				
 *
 */
public class ServiceMessageCounterUnitTest
{
    private ServiceMessageCounter counter;

    @Before
    public void setup() throws LifecycleResourceException
    {
		final ConfigTree config = createConfigTreeForScheduler();
		counter = ServiceMessageCounterLifecycleResource.getServiceMessageCounter(config);
    }
	@Test
	public void getObjectName() throws LifecycleResourceException
	{
		final ObjectName objectName = counter.getObjectName();
		assertEquals("jboss.esb:category=MessageCounter,deployment=ID-DEFAULT", objectName.getCanonicalName());
	}
	
	/**
	 * Test for JIRA: https://jira.jboss.org/jira/browse/JBESB-2522
	 */
	@Test
    public void getAttributesMissingKey() throws LifecycleResourceException, AttributeNotFoundException, MBeanException, ReflectionException
    {
        counter.update(new ActionStatusBean(100l, 0, MessageFactory.getInstance().getMessage(), ActionStatusBean.ACTION_SENT, ""));
        
        try
        {
            counter.getAttributes(new String[] {"boguskey"});
        }
        catch (final NullPointerException e)
        {
            e.printStackTrace();
            fail("getAttributes should not throw NPE if key does not exist. Exception was : " + e.getMessage());
        }
    }
	
	private ConfigTree createConfigTreeForScheduler()
	{
		ConfigTree parent = new ConfigTree("parent");
		parent.setAttribute("deployment", "sample.esb");
		
		ConfigTree config = new ConfigTree( "cronScheduleListener", parent);
		config.setAttribute( "composer", "class");
		config.setAttribute( "listenerClass", "org.jboss.soa.esb.listeners.ScheduleListener" );
		config.setAttribute( "scheduleidref", "cronTrigger");
		
		ConfigTree action = new ConfigTree(ListenerTagNames.ACTION_ELEMENT_TAG, parent);
		action.setAttribute("name", "testAction");
		
		return parent;
	}
	
	/*
	 * Just here to help Ant to find annotated test.
	 */
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter( ServiceMessageCounterUnitTest.class );
	}	

}
