/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.gateway.remotestrategies.cache;

import static org.junit.Assert.fail;

import java.io.File;

import org.jboss.cache.ConfigureException;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.soa.esb.testutils.HsqldbUtil;
import org.jboss.soa.esb.testutils.TestEnvironmentUtil;

/**
 * Simple helper class with util method for getting a cache config
 * file.
 * 
 * @author Daniel Bevenius				
 *
 */
public class FtpFileCacheTestUtil
{
	private static Object server;
	
	public static String getCacheConfigFile()
	{
		String configFile = TestEnvironmentUtil.getBaseDir() + File.separator + 
							"rosetta" + File.separator + 
							"tests" + File.separator + 
							"src" + File.separator + 
							"org" + File.separator + 
							"jboss" + File.separator + 
							"soa" + File.separator + 
							"esb" + File.separator + 
							"listeners" + File.separator + 
							"gateway" + File.separator + 
							"remotestrategies" + File.separator + 
							"cache" + File.separator + 
							"ftpfile_cache_test.xml";
		
		if ( ! new File ( configFile ).exists() )
			fail( "Could not locate the jboss cache config file: " +  configFile );
		
		return configFile;
	}
	
	public static void createTreeCache( TreeCache treeCache, String pathToConfigFile ) throws ConfigureException
	{
		PropertyConfigurator configurator = new PropertyConfigurator();
		configurator.configure( treeCache, pathToConfigFile );
	}
	
	public static void startDB() throws Exception
	{
		
		registerHsqlDriver();
		server = HsqldbUtil.startHsqldb(TestEnvironmentUtil.getUserDir() + "build" + File.separator + "hsqltestdb", "ftpcache");
	}
	
	private static void registerHsqlDriver()
	{
		try 
		{
			Class.forName( "org.hsqldb.jdbcDriver" );
		} 
		catch (Exception e) 
		{
			fail( "ERROR: failed to load JDBC driver." + e.getMessage() );
		}
	}
	
	public static void stopDB() throws Exception 
	{
		HsqldbUtil.stopHsqldb(server);
	}

}
