/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.http.configurators;

import static org.junit.Assert.*;

import java.util.Properties;

import junit.framework.JUnit4TestAdapter;

import org.apache.commons.httpclient.HttpClient;
import org.junit.Test;

/**
 * Unit test for {@link HttpProtocol}.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class HttpProtocolUnitTest
{
    private HttpClient httpClient = new HttpClient();
    private HttpProtocol httpProtocol = new HttpProtocol();
    
    @Test
    public void setHttpsProxyHostWithPort()
    {
        final String proxyHost = "192.87.22.1";
        final int proxyPort = 8899;
        final Properties properties = createHttpsProperties(proxyHost, proxyPort);
                
        httpProtocol.setHttpsProxyHost(httpClient, properties);
        
        assertEquals(proxyHost, httpClient.getHostConfiguration().getProxyHost());
        assertEquals(proxyPort, httpClient.getHostConfiguration().getProxyPort());
    }
    
    @Test
    public void setHttpsProxyHostDefaultPort()
    {
        final String proxyHost = "192.87.22.1";
        final Properties properties = createHttpsProperties(proxyHost, -1);
                
        httpProtocol.setHttpsProxyHost(httpClient, properties);
        
        assertEquals(proxyHost, httpClient.getHostConfiguration().getProxyHost());
        assertEquals(443, httpClient.getHostConfiguration().getProxyPort());
    }
    
    @Test
    public void setHttpProxyHostWithPort()
    {
        final String proxyHost = "192.87.22.1";
        final int proxyPort = 8899;
        final Properties properties = createHttpProperties(proxyHost, proxyPort);
                
        httpProtocol.setHttpProxyHost(httpClient, properties);
        
        assertEquals(proxyHost, httpClient.getHostConfiguration().getProxyHost());
        assertEquals(proxyPort, httpClient.getHostConfiguration().getProxyPort());
    }
    
    @Test
    public void setHttpProxyHostDefaultPort()
    {
        final String proxyHost = "192.87.22.8";
        final Properties properties = createHttpProperties(proxyHost, -1);
        
        httpProtocol.setHttpProxyHost(httpClient, properties);
        
        assertEquals(proxyHost, httpClient.getHostConfiguration().getProxyHost());
        assertEquals(80, httpClient.getHostConfiguration().getProxyPort());
    }
    
    private Properties createHttpProperties(final String host, final int port)
    {
        final Properties properties = new Properties();
        properties.setProperty("http.proxyHost", host);
        if (port != -1)
        {
            properties.setProperty("http.proxyPort", String.valueOf(port));
        }
        return properties;
    }
    
    private Properties createHttpsProperties(final String host, final int port)
    {
        final Properties properties = new Properties();
        properties.setProperty("https.proxyHost", host);
        if (port != -1)
        {
            properties.setProperty("https.proxyPort", String.valueOf(port));
        }
        return properties;
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(HttpProtocolUnitTest.class);
    }
}
