/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers.persist;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import junit.framework.JUnit4TestAdapter;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.testutils.HsqldbUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Unit tests for the SimpleDataSource class.
 *
 * @author <a href="mailto:jplenhart@yahoo.com">jplenhart@yahoo.com</a>
 */


public class SimpleDataSourceUnitTest
{

    private static final String PERSIST_DB_DIR = System.getProperty("org.jboss.esb.test.persistdb.dir",
    		"./rosetta/tests/resources/etc") ;
    private static String mDbDriver ="org.hsqldb.jdbcDriver";
    private static String mDbUrl = "jdbc:hsqldb:file:" + PERSIST_DB_DIR + "/persistUnitTestDB";
    private static String mDbUsername = "sa";
    private static String mDbPassword ="";
    private static Object server;

    private static Logger logger = Logger.getLogger(SimpleDataSourceUnitTest.class);




    /**
     * Setup the database.
     */
    @BeforeClass
    public static void runBeforeAllTests()
    {
        try
        {
            server = HsqldbUtil.startHsqldb(PERSIST_DB_DIR + "/persistUnitTestDB", "persistUnitTestDB");
        }
        catch (Exception e)
        {
			logger.error("No Database Available - Stop Testing", e);
            assertTrue(false);
        }

    }


    /**
     *
     * Instantiate with all Correct Parameters
     * Connect to the Database validate timeout
     */
    @Test
    public void instantiateAndSetTimeout()
    {
        try
        {
            SimpleDataSource simpleDS = new SimpleDataSource(mDbDriver, mDbUrl, mDbUsername, mDbPassword);

            simpleDS.setLoginTimeout(10000);
            assertEquals(simpleDS.getLoginTimeout(),10000);
        }
        catch (Exception _ex)
        {
            logger.error(_ex.getLocalizedMessage(), _ex);
            assertTrue(false);
        }

    }

    /**
     *
     * Instantiate with all Correct Parameters
     * Connect to the Database and Run a Simple
     * Query
     */
    @Test
    public void instantiateWithCorrectParameters()
    {

        try
        {
            SimpleDataSource simpleDS = new SimpleDataSource(mDbDriver, mDbUrl, mDbUsername, mDbPassword);
            // Grab the connection created and do a simple Query - we expect a result
            Connection con = simpleDS.getConnection();
            Statement stat = con.createStatement();
            ResultSet rs = stat.executeQuery("select * from message");

            if(rs.next())
                assertTrue(true);
            else
                assertTrue(false);
        }
        catch (Exception _ex)
        {
            logger.error(_ex.getLocalizedMessage(), _ex);
            assertTrue(false);
        }
    }

    /**
     *
     * Instantiate with InCorrect Parameters
     * Connect to the Database - verify it errors properly
     * by throwing an Exception
     */
    @Test
    public void instantiateWithInCorrectParameters()
    {

        try
        {
            // Setting a Bogus Driver
            SimpleDataSource simpleDS = new SimpleDataSource("bogusDriver", mDbUrl, mDbUsername, mDbPassword);
            logger.log(Level.INFO, simpleDS); 
            assertTrue(false);
        }
        catch (Exception _ex)
        {
            // This is Expected
            assertTrue(true);
        }

    }



    /**
     * Shutdown the database
     *
     * @throws Exception
     */
    @AfterClass
    public static void runAfterAllTests() throws Exception
    {
        if ("org.hsqldb.jdbcDriver".equals(mDbDriver))
        {
            HsqldbUtil.stopHsqldb(server);
            logger.debug("Database Shutdown Complete");
        }
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(SimpleDataSourceUnitTest.class);
    }



}
