/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers.persist;

import static org.junit.Assert.assertTrue;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.testutils.HsqldbUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Unit tests for the JdbcCleanConn class.
 *
 * @author <a href="mailto:jplenhart@yahoo.com">jplenhart@yahoo.com</a>
 */


public class JdbcCleanConnUnitTest
{

    private static final String PERSIST_DB_DIR = System.getProperty("org.jboss.esb.test.persistdb.dir",
    		"./rosetta/tests/resources/etc") ;
    private static String mDbDriver ="org.hsqldb.jdbcDriver";
    private static String mDbUrl = "jdbc:hsqldb:file:" + PERSIST_DB_DIR + "/persistUnitTestDB";
    private static String mDbUsername = "sa";
    private static String mDbPassword ="";
    private static Object server ;

    /**
     * Setup the database.
     */
    @BeforeClass
    public static void runBeforeAllTests()
    {
        try
        {
            server = HsqldbUtil.startHsqldb(PERSIST_DB_DIR + "/persistUnitTestDB", "persistUnitTestDB");
        }
        catch (Exception e)
        {
            e.printStackTrace();
            System.out.println("No Database Available - Stop Testing");
            assertTrue(false);
        }

    }


    /**
     *
     * Instantiate with all Correct Parameters
     * Using our SimpleDataSource and verify we can
     * connect to the database
     */
    @Test
    public void instantiateWithSimpleDataSource()
    {
        try
        {
            SimpleDataSource ds = new SimpleDataSource(mDbDriver, mDbUrl, mDbUsername, mDbPassword);
            JdbcCleanConn jClnConn = new JdbcCleanConn(ds);
            PreparedStatement pstat = jClnConn.prepareStatement("select * from message", ResultSet.TYPE_FORWARD_ONLY,ResultSet.CONCUR_READ_ONLY);
            //Now Execute the PreparedStatement
            ResultSet rs = jClnConn.execQueryWait(pstat,1);

            if(rs.next())
                assertTrue(true);
            else
                assertTrue(false);


        }
        catch (Exception _ex)
        {
            _ex.printStackTrace();
            assertTrue(false);
        }

    }




    /**
     * Shutdown the database
     *
     * @throws Exception
     */
    @AfterClass
    public static void runAfterAllTests() throws Exception
    {
        if ("org.hsqldb.jdbcDriver".equals(mDbDriver))
        {
            HsqldbUtil.stopHsqldb(server);
            System.out.println("Database Shutdown Complete");
        }

    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(JdbcCleanConnUnitTest.class);
    }



}