/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.converters;

import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * ConfigTreeBuilder for XStream unit tests.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public class XStreamConfigBuilder
{
    private ConfigTree config;

    public XStreamConfigBuilder()
    {
        config = new ConfigTree("config");
    }

    public XStreamConfigBuilder classAlias(final String classAlias)
    {
        config.setAttribute("class-alias", classAlias);
        return this;
    }

    public XStreamConfigBuilder excludePackage(final boolean excludePackage)
    {
        config.setAttribute("exclude-package", String.valueOf(excludePackage));
        return this;
    }

    public XStreamConfigBuilder incomingType(final String type)
    {
        config.setAttribute("incoming-type", type);
        return this;
    }

    public XStreamConfigBuilder rootNodeName(final String rootNodeName)
    {
        config.setAttribute("root-node", rootNodeName);
        return this;
    }

    public XStreamConfigBuilder alias(final String aliasName, final String className)
    {
        ConfigTree alias1 = new ConfigTree("alias", config);
        alias1.setAttribute("name", aliasName);
        alias1.setAttribute("class", className);
        return this;
    }

    public XStreamConfigBuilder attributeAlias(final String aliasName, final String className)
    {
        ConfigTree attrAlias = new ConfigTree("attribute-alias", config);
        attrAlias.setAttribute("name", aliasName);
        attrAlias.setAttribute("class", className);
        return this;
    }

    public XStreamConfigBuilder fieldAlias(final String aliasName, final Class<?> definedIn, final String fieldName)
    {
        ConfigTree attrAlias = new ConfigTree("field-alias", config);
        attrAlias.setAttribute("alias", aliasName);
        attrAlias.setAttribute("definedIn", definedIn.getName());
        attrAlias.setAttribute("fieldName", fieldName);
        return this;
    }
    
    public XStreamConfigBuilder implicitCollection(final String ownerType, final String fieldName)
    {
        ConfigTree attrAlias = new ConfigTree("implicit-collection", config);
        attrAlias.setAttribute("ownerType", ownerType);
        attrAlias.setAttribute("fieldName", fieldName);
        return this;
    }
    
    public XStreamConfigBuilder implicitCollection(final String ownerType, final String fieldName, final String itemType)
    {
        ConfigTree attrAlias = new ConfigTree("implicit-collection", config);
        attrAlias.setAttribute("ownerType", ownerType);
        attrAlias.setAttribute("fieldName", fieldName);
        attrAlias.setAttribute("itemType", itemType);
        return this;
    }

    public XStreamConfigBuilder implicitCollection(final String ownerType, final String fieldName, final String itemFieldType, final String itemType)
    {
        ConfigTree attrAlias = new ConfigTree("implicit-collection", config);
        attrAlias.setAttribute("ownerType", ownerType);
        attrAlias.setAttribute("fieldName", fieldName);
        attrAlias.setAttribute("itemFieldName", itemFieldType);
        attrAlias.setAttribute("itemType", itemType);
        return this;
    }

    public XStreamConfigBuilder namespace(final String ns, final String localPart)
    {
        ConfigTree namespace = new ConfigTree("namespace", config);
        namespace.setAttribute(ObjectToXStream.ATTR_NAMESPACE_URI, ns);
        namespace.setAttribute(ObjectToXStream.ATTR_NAMESPACE_LOCALPART, localPart);
        return this;
    }

    public XStreamConfigBuilder converter(final String className)
    {
        ConfigTree converter = new ConfigTree("converter", config);
        converter.setAttribute("class", className);
        return this;
    }

    public XStreamConfigBuilder converter(final String className, int priority)
    {
        ConfigTree converter = new ConfigTree("converter", config);
        converter.setAttribute("class", className);
        converter.setAttribute("priority", String.valueOf(priority));
        return this;
    }

    public ConfigTree build()
    {
        return config;
    }
}