/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions;

import junit.framework.TestCase;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class AggregationDetailsUnitTest extends TestCase {

    public void test_multi_args() throws MessageDeliverException {
        test_invalid_multi_args("", 1, 1, 1, "null or empty 'seriesUuid' arg in method call.");
        test_invalid_multi_args("x", -1, 1, 1, "Invalid AggregatorDetails.  messageNumber < 1");
        test_invalid_multi_args("x", 1, -1, 1, "Invalid AggregatorDetails.  seriesSize < messageNumber");
        test_invalid_multi_args("x", 1, 1, -1, "Invalid AggregatorDetails.  timestamp < 1");

        // This should work...
        new AggregationDetails("x", 1, 1, 1);
    }

    private void test_invalid_multi_args(String seriesUuid, int messageNumber, int seriesSize, long seriesTimestamp, String errorMessage) {
        try {
            new AggregationDetails(seriesUuid, messageNumber, seriesSize, seriesTimestamp);
            fail("Expected IllegalArgumentException/MessageDeliverException");
        } catch(IllegalArgumentException e) {
            assertEquals(errorMessage, e.getMessage());
        }
    }

    public void test_tag_arg() throws MessageDeliverException {
        test_invalid_tag_arg("", "null or empty 'aggregatorTag' arg in method call.");
        test_invalid_tag_arg("1:1:1", "Invalid Aggregator Tag.  Must have 4 tokens (colon separated).");
        test_invalid_tag_arg(":1:1:1", "Invalid Aggregator Tag: seriesUuid is blank.");
        test_invalid_tag_arg("xxx:x:1:1", "Invalid Aggregator Tag.  'messageNumber' must be an int.");
        test_invalid_tag_arg("xxx:1:x:1", "Invalid Aggregator Tag.  'seriesSize' must be an int.");
        test_invalid_tag_arg("xxx:1:1:x", "Invalid Aggregator Tag.  'timestamp' must be an long.");
        test_invalid_tag_arg("xxx:-1:1:1", "Invalid Aggregator Tag.  messageNumber < 1");
        test_invalid_tag_arg("xxx:1:-1:1", "Invalid Aggregator Tag.  seriesSize < messageNumber");
        test_invalid_tag_arg("xxx:1:1:-1", "Invalid Aggregator Tag.  timestamp < 1");

        // This should work...
        new AggregationDetails("xxx:1:1:1");        
    }

    private void test_invalid_tag_arg(String tag, String errorMessage) {
        try {
            new AggregationDetails(tag);
            fail("Expected IllegalArgumentException/MessageDeliverException");
        } catch(IllegalArgumentException e) {
            assertEquals(errorMessage, e.getMessage());
        }
    }
}
