/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb;

import junit.framework.TestCase;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ServiceUnitTest extends TestCase {

    public void test_equals() {
        List<Service> list = new ArrayList<Service>();

        list.add(new Service("a", "b"));
        list.add(new Service("c", "d"));
        assertTrue(list.contains(new Service("a", "b")));
        assertTrue(list.contains(new Service("c", "d")));
        assertFalse(list.contains(new Service("e", "f")));
    }

    public void test_hashcode() {
        Map<Service, String> map = new HashMap<Service, String>();

        map.put(new Service("a", "b"), "1");
        map.put(new Service("c", "d"), "2");
        map.put(new Service("x", "y"), null);
        assertEquals("1", map.get(new Service("a", "b")));
        assertEquals("2", map.get(new Service("c", "d")));
        assertEquals(null, map.get(new Service("e", "f")));
        assertTrue(map.containsKey(new Service("x", "y")));
    }
}
