package org.jboss.internal.soa.esb.couriers.transport;

import java.net.URI;

import org.jboss.soa.esb.addressing.eprs.InVMEpr;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.Test;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;

/**
 * InVMTemporaryTransport unit tests.
 * 
 * Most of the delivery functionality is covered by the InVM courier unit tests.
 * 
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class InVMTemporaryTransportUnitTest
{
    @Test
    public void testExpiry()
        throws Exception
    {
        final String currentExpiryTime = System.getProperty(Environment.INVM_EXPIRY_TIME) ;
        try
        {
            final long expiryTime = 5000 ;
            System.setProperty(Environment.INVM_EXPIRY_TIME, Long.toString(expiryTime)) ;
            final InVMTemporaryTransport transport = new InVMTemporaryTransport() ;
            transport.startReaper() ;
            try
            {
                final InVMEpr epr = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://epr1")) ;
                final Message message = MessageFactory.getInstance().getMessage() ;
                
                Assert.assertEquals("Ordered entry size", 0, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 0, transport.getServiceIdToEntrySize()) ;
                
                transport.deliver(epr, message) ;
                
                Assert.assertEquals("Ordered entry size", 1, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 1, transport.getServiceIdToEntrySize()) ;
                
                Thread.sleep(expiryTime*2) ;
                
                Assert.assertEquals("Ordered entry size", 0, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 0, transport.getServiceIdToEntrySize()) ;
            }
            finally
            {
                transport.stopReaper() ;
            }
        }
        finally
        {
            if (currentExpiryTime == null)
            {
                System.getProperties().remove(Environment.INVM_EXPIRY_TIME) ;
            }
            else
            {
                System.setProperty(Environment.INVM_EXPIRY_TIME, currentExpiryTime) ;
            }
        }
    }
    
    @Test
    public void testMultipleExpiries()
        throws Exception
    {
        final String currentExpiryTime = System.getProperty(Environment.INVM_EXPIRY_TIME) ;
        try
        {
            final long expiryTime = 5000 ;
            System.setProperty(Environment.INVM_EXPIRY_TIME, Long.toString(expiryTime)) ;
            final InVMTemporaryTransport transport = new InVMTemporaryTransport() ;
            transport.startReaper() ;
            try
            {
                final InVMEpr epr = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://epr1")) ;
                final Message message = MessageFactory.getInstance().getMessage() ;
                
                Assert.assertEquals("Ordered entry size", 0, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 0, transport.getServiceIdToEntrySize()) ;
                
                transport.deliver(epr, message) ;
                Thread.sleep(100) ;
                transport.deliver(epr, message) ;
                Thread.sleep(100) ;
                transport.deliver(epr, message) ;
                Thread.sleep(100) ;
                transport.deliver(epr, message) ;
                Thread.sleep(100) ;
                transport.deliver(epr, message) ;
                
                Assert.assertEquals("Ordered entry size", 5, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 1, transport.getServiceIdToEntrySize()) ;
                
                Thread.sleep(expiryTime*2) ;
                
                Assert.assertEquals("Ordered entry size", 0, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 0, transport.getServiceIdToEntrySize()) ;
            }
            finally
            {
                transport.stopReaper() ;
            }
        }
        finally
        {
            if (currentExpiryTime == null)
            {
                System.getProperties().remove(Environment.INVM_EXPIRY_TIME) ;
            }
            else
            {
                System.setProperty(Environment.INVM_EXPIRY_TIME, currentExpiryTime) ;
            }
        }
    }
    
    @Test
    public void testMultipleExpiriesMultipleEPRs()
        throws Exception
    {
        final String currentExpiryTime = System.getProperty(Environment.INVM_EXPIRY_TIME) ;
        try
        {
            final long expiryTime = 5000 ;
            System.setProperty(Environment.INVM_EXPIRY_TIME, Long.toString(expiryTime)) ;
            final InVMTemporaryTransport transport = new InVMTemporaryTransport() ;
            transport.startReaper() ;
            try
            {
                final InVMEpr epr1 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://epr1")) ;
                final InVMEpr epr2 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://epr2")) ;
                final InVMEpr epr3 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://epr3")) ;
                final InVMEpr epr4 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://epr4")) ;
                final InVMEpr epr5 = new InVMEpr(URI.create(InVMEpr.INVM_PROTOCOL + "://epr5")) ;
                final Message message = MessageFactory.getInstance().getMessage() ;
                
                Assert.assertEquals("Ordered entry size", 0, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 0, transport.getServiceIdToEntrySize()) ;
                
                transport.deliver(epr1, message) ;
                Thread.sleep(100) ;
                transport.deliver(epr2, message) ;
                Thread.sleep(100) ;
                transport.deliver(epr3, message) ;
                Thread.sleep(100) ;
                transport.deliver(epr4, message) ;
                Thread.sleep(100) ;
                transport.deliver(epr5, message) ;
                
                Assert.assertEquals("Ordered entry size", 5, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 5, transport.getServiceIdToEntrySize()) ;
                
                Thread.sleep(expiryTime*2) ;
                
                Assert.assertEquals("Ordered entry size", 0, transport.getOrderedEntriesSize()) ;
                Assert.assertEquals("Service id size", 0, transport.getServiceIdToEntrySize()) ;
            }
            finally
            {
                transport.stopReaper() ;
            }
        }
        finally
        {
            if (currentExpiryTime == null)
            {
                System.getProperties().remove(Environment.INVM_EXPIRY_TIME) ;
            }
            else
            {
                System.setProperty(Environment.INVM_EXPIRY_TIME, currentExpiryTime) ;
            }
        }
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(InVMTemporaryTransportUnitTest.class);
    }
}
