/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.util.ssl;

import org.jboss.soa.esb.ConfigurationException;

import javax.net.ssl.X509TrustManager;
import javax.net.ssl.TrustManager;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

/**
 * {@link X509TrustManager} that trusts Self-Signed certificates.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class SelfSignedTrustManager implements X509TrustManager {

    private X509TrustManager trustManager;

    public SelfSignedTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException, ConfigurationException {
        TrustManager[] trustManagers = SSLUtil.getTrustManagers(keystore);
        if(trustManagers.length == 0) {
            throw new ConfigurationException("No TrustManagers found in KeyStore.");
        }
        try {
            trustManager = (X509TrustManager) trustManagers[0];
        } catch(ClassCastException e) {
            throw new ConfigurationException("X509 TrustManager not found in KeyStore.");
        }
    }
    
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        trustManager.checkClientTrusted(x509Certificates, authType);
    }

    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        if ((x509Certificates != null) && (x509Certificates.length == 1)) {
            x509Certificates[0].checkValidity();
        } else {
            trustManager.checkServerTrusted(x509Certificates, authType);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return trustManager.getAcceptedIssuers();
    }
}
